/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import org.apache.jena.atlas.lib.Lib;

public class AggSample
extends AggregatorBase {
    public AggSample(Expr expr) {
        super("SAMPLE", false, expr);
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggSample(exprs.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccSample(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return null;
    }

    @Override
    public int hashCode() {
        return 0x17A ^ this.getExpr().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggSample)) {
            return false;
        }
        AggSample agg = (AggSample)other;
        return Lib.equal(this.exprList, agg.exprList);
    }

    private static class AccSample
    extends AccumulatorExpr {
        private NodeValue sampleSoFar = null;

        public AccSample(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (this.sampleSoFar == null) {
                this.sampleSoFar = nv;
                return;
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return this.sampleSoFar;
        }
    }
}

