/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql;

import edu.uiuc.ncsa.security.core.Initializable;
import edu.uiuc.ncsa.security.storage.sql.AdminConnectionParameters;
import edu.uiuc.ncsa.security.storage.sql.ConnectionParameters;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.SQLDatabase;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.Statement;

public class TableInitializer
extends SQLDatabase
implements Initializable {
    Table table;
    boolean isNew = false;
    boolean isDestroyed = false;
    boolean isInit = false;

    public TableInitializer(ConnectionPool connectionPool, Table table) {
        super(connectionPool);
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNew() {
        this.isNew = false;
        Connection c = this.getConnection();
        try {
            ConnectionParameters cp = this.getConnectionPool().getConnectionParameters();
            String username = cp.getUsername();
            if (cp instanceof AdminConnectionParameters) {
                AdminConnectionParameters acp = (AdminConnectionParameters)cp;
                username = ((AdminConnectionParameters)cp).getClientUsername();
            }
            Statement stmt = c.createStatement();
            stmt.execute(this.table.createTableStatement());
            stmt.execute("GRANT SELECT,INSERT,UPDATE TO " + this.table.getFQTablename() + " TO " + username);
            stmt.close();
            this.isNew = true;
            this.isInit = true;
            this.isDestroyed = false;
        }
        catch (Exception x) {
            this.destroyConnection(c);
        }
        finally {
            this.releaseConnection(c);
        }
        return this.isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        this.isDestroyed = false;
        Connection c = this.getConnection();
        try {
            Statement stmt = c.createStatement();
            String x = "Drop Table " + this.table.getFQTablename();
            stmt.execute(x);
            stmt.close();
            this.isDestroyed = true;
            this.isNew = false;
            this.isInit = false;
        }
        catch (Exception x) {
            this.destroyConnection(c);
        }
        finally {
            this.releaseConnection(c);
        }
        return this.isDestroyed;
    }

    public boolean init() {
        this.isInit = true;
        this.isInit = this.isInit && this.destroy() && this.createNew();
        return this.isInit;
    }

    public boolean isCreated() {
        return this.isNew;
    }

    public boolean isInitialized() {
        return this.isInit;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }
}

