/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.TDBMaker;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;

public class TDBFactory {
    private TDBFactory() {
    }

    public static Dataset assembleDataset(String assemblerFile) {
        return (Dataset)AssemblerUtils.build((String)assemblerFile, (Resource)VocabTDB.tDatasetTDB);
    }

    public static Dataset createDataset(String dir) {
        return TDBFactory.createDataset(new Location(dir));
    }

    public static Dataset createDataset(Location location) {
        return TDBFactory.createDataset(TDBFactory.createDatasetGraph(location));
    }

    public static Dataset createDataset() {
        return TDBFactory.createDataset(TDBFactory.createDatasetGraph());
    }

    private static Dataset createDataset(DatasetGraph datasetGraph) {
        return DatasetFactory.create((DatasetGraph)datasetGraph);
    }

    public static DatasetGraph createDatasetGraph(String directory) {
        return TDBFactory.createDatasetGraph(new Location(directory));
    }

    public static DatasetGraph createDatasetGraph(Location location) {
        return TDBFactory._createDatasetGraph(location);
    }

    public static DatasetGraph createDatasetGraph() {
        return TDBFactory._createDatasetGraph();
    }

    public static void release(Dataset dataset) {
        TDBFactory._release(TDBFactory.location(dataset));
    }

    public static void release(DatasetGraph dataset) {
        TDBFactory._release(TDBFactory.location(dataset));
    }

    public static void reset() {
        TDBMaker.reset();
    }

    private static DatasetGraph _createDatasetGraph(Location location) {
        return TDBMaker.createDatasetGraphTransaction(location);
    }

    private static DatasetGraph _createDatasetGraph() {
        return TDBMaker.createDatasetGraphTransaction();
    }

    private static void _release(Location location) {
        if (location == null) {
            return;
        }
        TDBMaker.releaseLocation(location);
    }

    public static boolean isBackedByTDB(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        return TDBFactory.isBackedByTDB(dsg);
    }

    public static boolean isBackedByTDB(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof DatasetGraphTransaction) {
            return true;
        }
        return datasetGraph instanceof DatasetGraphTDB;
    }

    public static Location location(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        return TDBFactory.location(dsg);
    }

    public static Location location(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof DatasetGraphTDB) {
            return ((DatasetGraphTDB)datasetGraph).getLocation();
        }
        if (datasetGraph instanceof DatasetGraphTransaction) {
            return ((DatasetGraphTransaction)datasetGraph).getLocation();
        }
        return null;
    }

    @Deprecated
    public static Graph assembleGraph(String assemblerFile) {
        Model m = TDBFactory.assembleModel(assemblerFile);
        Graph g = m.getGraph();
        return g;
    }

    @Deprecated
    public static Model assembleModel(String assemblerFile) {
        return (Model)AssemblerUtils.build((String)assemblerFile, (Resource)VocabTDB.tGraphTDB);
    }

    @Deprecated
    public static Model createModel(Location loc) {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph(loc));
    }

    @Deprecated
    public static Model createModel(String dir) {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph(dir));
    }

    @Deprecated
    public static Model createModel() {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph());
    }

    @Deprecated
    public static Model createNamedModel(String name, String location) {
        return TDBFactory.createDataset(location).getNamedModel(name);
    }

    @Deprecated
    public static Model createNamedModel(String name, Location location) {
        return TDBFactory.createDataset(location).getNamedModel(name);
    }

    @Deprecated
    public static Graph createGraph(Location loc) {
        return TDBFactory.createDatasetGraph(loc).getDefaultGraph();
    }

    @Deprecated
    public static Graph createGraph(String dir) {
        Location loc = new Location(dir);
        return TDBFactory.createGraph(loc);
    }

    @Deprecated
    public static Graph createGraph() {
        return TDBFactory.createDatasetGraph().getDefaultGraph();
    }

    @Deprecated
    public static Graph createNamedGraph(String name, String location) {
        return TDBFactory.createDatasetGraph(location).getGraph(NodeFactory.createURI((String)name));
    }

    @Deprecated
    public static Graph createNamedGraph(String name, Location location) {
        return TDBFactory.createDatasetGraph(location).getGraph(NodeFactory.createURI((String)name));
    }
}

