/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.riot.writer.WriterStreamRDFTuples;

public class NTriplesWriter
extends WriterGraphRIOTBase {
    private final CharSpace charSpace;

    public static void write(OutputStream out, Iterator<Triple> iter) {
        NTriplesWriter.write(out, iter, CharSpace.UTF8);
    }

    public static void write(OutputStream out, Iterator<Triple> iter, CharSpace charSpace) {
        StreamRDF s = StreamRDFLib.writer(out, charSpace);
        NTriplesWriter.write$(s, iter);
    }

    public static void write(Writer out, Iterator<Triple> iter) {
        NTriplesWriter.write(out, iter, CharSpace.UTF8);
    }

    public static void write(Writer out, Iterator<Triple> iter, CharSpace charSpace) {
        StreamRDF s = StreamRDFLib.writer(out, charSpace);
        NTriplesWriter.write$(s, iter);
    }

    private static void write$(StreamRDF s, Iterator<Triple> iter) {
        s.start();
        StreamRDFLib.triplesToStream(s, iter);
        s.finish();
    }

    public NTriplesWriter() {
        this(CharSpace.UTF8);
    }

    public NTriplesWriter(CharSpace charSpace) {
        this.charSpace = charSpace;
    }

    @Override
    public Lang getLang() {
        return Lang.NTRIPLES;
    }

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        ExtendedIterator iter = graph.find(null, null, null);
        if (this.charSpace == CharSpace.UTF8) {
            NTriplesWriter.write(out, (Iterator<Triple>)iter);
        } else {
            WriterStreamRDFTuples s = new WriterStreamRDFTuples(IO.wrap(out), CharSpace.ASCII);
            NTriplesWriter.write$(s, (Iterator<Triple>)iter);
        }
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        ExtendedIterator iter = graph.find(null, null, null);
        if (this.charSpace == CharSpace.UTF8) {
            NTriplesWriter.write(out, (Iterator<Triple>)iter);
        } else {
            WriterStreamRDFTuples s = new WriterStreamRDFTuples(IO.wrapASCII(out), CharSpace.ASCII);
            NTriplesWriter.write$(s, (Iterator<Triple>)iter);
        }
    }
}

