/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v1.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.util.DateTimeMarshaller;

public class TypeCompareUtil {
    static Logger logger = Logger.getLogger((String)TypeCompareUtil.class.getName());

    public static List<String> compareSystemMetadata(SystemMetadata sysmeta1, SystemMetadata sysmeta2) {
        LinkedHashMap<String, Object> labeledSysmeta = new LinkedHashMap<String, Object>();
        labeledSysmeta.put("sysmeta 1", sysmeta1);
        labeledSysmeta.put("sysmeta 2", sysmeta2);
        return TypeCompareUtil.compareD1ServiceType(labeledSysmeta, true);
    }

    public static List<String> compareD1ServiceType(Map<String, Object> d1ServiceTypeMap, Boolean sortArrays) {
        if (sortArrays == null) {
            sortArrays = true;
        }
        LinkedList<String> report = new LinkedList<String>();
        HashMap<String, LinkedHashMap<String, String>> d1TypePropMap = new HashMap<String, LinkedHashMap<String, String>>();
        TreeSet propKeys = new TreeSet();
        for (String label : d1ServiceTypeMap.keySet()) {
            LinkedHashMap<String, String> smdProps = TypeCompareUtil.getD1SubtypesListing("", d1ServiceTypeMap.get(label), sortArrays);
            propKeys.addAll(smdProps.keySet());
            d1TypePropMap.put(label, smdProps);
        }
        Set nodeKeys = d1TypePropMap.keySet();
        StringBuffer sb = new StringBuffer();
        sb.append("property field");
        for (String key : nodeKeys) {
            sb.append("\t" + key);
        }
        report.add(sb.toString());
        for (String prop : propKeys) {
            sb = new StringBuffer();
            sb.append(prop);
            LinkedList<String> values = new LinkedList<String>();
            for (String nodeKey : nodeKeys) {
                sb.append("\t");
                String value = null;
                value = d1TypePropMap.get(nodeKey) instanceof LinkedHashMap ? (String)((LinkedHashMap)d1TypePropMap.get(nodeKey)).get(prop) : (String)d1TypePropMap.get(nodeKey);
                sb.append(value);
                if (values.contains(value)) continue;
                values.add(value);
            }
            if (values.size() <= 1) continue;
            report.add(sb.toString());
        }
        if (report.size() == 1) {
            report.clear();
            report.add("OK");
        }
        return report;
    }

    public static LinkedHashMap<String, String> getD1SubtypesListing(Object o) {
        return TypeCompareUtil.getD1SubtypesListing(o.getClass().getSimpleName(), o, true);
    }

    public static LinkedHashMap<String, String> getD1SubtypesListing(String path, Object o, boolean sortArrays) {
        return TypeCompareUtil.getD1SubtypesListing(path, o, sortArrays, false);
    }

    public static LinkedHashMap<String, String> getD1SubtypesListing(String path, Object o, boolean sortArrays, boolean flattenSimpleTypeLists) {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        if (o == null) {
            results.put(path, "null");
        } else {
            Class<?> cl = o.getClass();
            logger.debug((Object)("listing for: " + path + ": " + cl.getName()));
            if (cl.getPackage().getName().startsWith("org.dataone.service.types")) {
                Method[] methods;
                for (Method m : methods = o.getClass().getMethods()) {
                    if ((!m.getName().startsWith("get") || m.getName().equals("getClass") || m.getParameterTypes().length != 0) && !m.getName().equals("xmlValue")) continue;
                    try {
                        Object p = m.invoke(o, (Object[])null);
                        LinkedHashMap<String, String> subresults = TypeCompareUtil.getD1SubtypesListing(path + "/" + m.getName().replace("get", ""), p, sortArrays, flattenSimpleTypeLists);
                        results.putAll(subresults);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)m.getName(), (Throwable)e);
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)m.getName(), (Throwable)e);
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        logger.error((Object)m.getName(), (Throwable)e);
                        e.printStackTrace();
                    }
                }
            } else if (o instanceof String) {
                results.put(path, (String)o);
            } else if (o instanceof Integer) {
                results.put(path, ((Integer)o).toString());
            } else if (o instanceof Date) {
                results.put(path, DateTimeMarshaller.serializeDateToUTC((Date)o));
            } else if (o instanceof BigInteger) {
                results.put(path, ((BigInteger)o).toString());
            } else if (o instanceof Boolean) {
                results.put(path, ((Boolean)o).toString());
            } else if (o instanceof Map) {
                Map map = (Map)o;
                for (Map.Entry entry : map.entrySet()) {
                    results.putAll(TypeCompareUtil.getD1SubtypesListing(path + "/" + entry.getKey(), entry.getValue(), sortArrays, flattenSimpleTypeLists));
                }
            } else if (o instanceof List) {
                List list = (List)o;
                if (!list.isEmpty()) {
                    if (sortArrays) {
                        logger.debug((Object)("arrayList size: " + list.size()));
                        if (list.get(0) instanceof Comparable) {
                            Collections.sort(list);
                        } else if (list.get(0) instanceof Replica) {
                            Collections.sort(list, new Comparator<Replica>(){

                                @Override
                                public int compare(Replica r1, Replica r2) {
                                    return r1.getReplicaMemberNode().compareTo(r2.getReplicaMemberNode());
                                }
                            });
                        } else if (list.get(0) instanceof AccessRule) {
                            Collections.sort(list, new Comparator<AccessRule>(){

                                @Override
                                public int compare(AccessRule ar1, AccessRule ar2) {
                                    StringBuffer ar1SB = new StringBuffer();
                                    Collections.sort(ar1.getSubjectList());
                                    for (Subject s : ar1.getSubjectList()) {
                                        ar1SB.append(s.getValue());
                                    }
                                    String ar1Subjects = ar1SB.toString();
                                    StringBuffer ar2SB = new StringBuffer();
                                    Collections.sort(ar2.getSubjectList());
                                    for (Subject s : ar2.getSubjectList()) {
                                        ar2SB.append(s.getValue());
                                    }
                                    String ar2Subjects = ar2SB.toString();
                                    return ar1Subjects.compareTo(ar2Subjects);
                                }
                            });
                        }
                    }
                    boolean flattened = false;
                    if (flattenSimpleTypeLists) {
                        StringBuffer sb;
                        if (list.get(0) instanceof Subject) {
                            flattened = true;
                            sb = new StringBuffer();
                            for (Serializable s : list) {
                                sb.append(((Subject)s).getValue());
                                sb.append(',');
                            }
                            sb.deleteCharAt(sb.length() - 1);
                            results.put(path, sb.toString());
                        } else if (list.get(0) instanceof NodeReference) {
                            flattened = true;
                            sb = new StringBuffer();
                            for (Serializable s : list) {
                                sb.append(((NodeReference)s).getValue());
                                sb.append(',');
                            }
                            sb.deleteCharAt(sb.length() - 1);
                            results.put(path, sb.toString());
                        } else if (list.get(0) instanceof Identifier) {
                            flattened = true;
                            sb = new StringBuffer();
                            for (Serializable s : list) {
                                sb.append(((Identifier)s).getValue());
                                sb.append(',');
                            }
                            sb.deleteCharAt(sb.length() - 1);
                            results.put(path, sb.toString());
                        } else if (list.get(0) instanceof ObjectFormatIdentifier) {
                            flattened = true;
                            sb = new StringBuffer();
                            for (Serializable s : list) {
                                sb.append(((ObjectFormatIdentifier)s).getValue());
                                sb.append(',');
                            }
                            sb.deleteCharAt(sb.length() - 1);
                            results.put(path, sb.toString());
                        } else if (list.get(0) instanceof Permission) {
                            flattened = true;
                            sb = new StringBuffer();
                            for (Serializable s : list) {
                                sb.append(((Permission)s).xmlValue());
                                sb.append(',');
                            }
                            sb.deleteCharAt(sb.length() - 1);
                            results.put(path, sb.toString());
                        }
                    }
                    if (!flattened) {
                        for (int j = 0; j < list.size(); ++j) {
                            results.putAll(TypeCompareUtil.getD1SubtypesListing(path + "/" + j, list.get(j), sortArrays, flattenSimpleTypeLists));
                        }
                    }
                } else {
                    results.put(path, "null");
                }
            }
        }
        logger.debug((Object)"(return)");
        return results;
    }

    public static List<String> reportSubtypesListing(Object o, Boolean sort) {
        if (sort == null) {
            sort = Boolean.TRUE;
        }
        LinkedHashMap<String, String> map = TypeCompareUtil.getD1SubtypesListing("", o, sort);
        ArrayList<String> report = new ArrayList<String>();
        report.add("field_name\tfield_value");
        for (String key : map.keySet()) {
            report.add(String.format("%s\t%s", key, map.get(key)));
        }
        return report;
    }
}

