/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.queryservice;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import org.apache.axis.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.stub.QueryServiceLocator;
import org.ecoinformatics.ecogrid.queryservice.stub.QueryServicePortType;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryParser;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetTransformer;

public class QueryServiceClient {
    private QueryServicePortType ecogrid;
    static Log log = LogFactory.getLog((String)QueryServiceClient.class.getName());

    public QueryServiceClient(URL uRL) throws Exception {
        long l = System.currentTimeMillis();
        QueryServiceLocator queryServiceLocator = new QueryServiceLocator();
        this.ecogrid = queryServiceLocator.getQuery(uRL);
        Stub stub = (Stub)this.ecogrid;
        stub.setTimeout(10000000);
        long l2 = System.currentTimeMillis();
        log.debug((Object)("The time to create instance is =========== " + (l2 - l) / 1000L));
    }

    public QueryServiceClient(String string) throws Exception {
        this(new URL(string));
    }

    public ResultsetType query(QueryType queryType) throws Exception {
        ResultsetType resultsetType = null;
        if (this.ecogrid != null) {
            long l = System.currentTimeMillis();
            resultsetType = this.ecogrid.query(queryType);
            long l2 = System.currentTimeMillis();
            log.debug((Object)("The query time is ==============" + (l2 - l) / 1000L));
        }
        return resultsetType;
    }

    public ResultsetType query(Reader reader) {
        ResultsetType resultsetType = null;
        try {
            EcogridQueryParser ecogridQueryParser = new EcogridQueryParser(reader);
            ecogridQueryParser.parseXML();
            QueryType queryType = ecogridQueryParser.getEcogridQuery();
            resultsetType = this.query(queryType);
        }
        catch (Exception exception) {
            System.err.println("ERROR!");
            exception.printStackTrace();
        }
        return resultsetType;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            System.out.println("Usage: java  QueryServiceClient <service url> <query_filename> (outputfile)");
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = null;
        if (stringArray.length == 3) {
            string3 = stringArray[2];
        }
        try {
            QueryServiceClient queryServiceClient = new QueryServiceClient(string);
            String string4 = null;
            File file = new File(string2);
            FileReader fileReader = new FileReader(file);
            ResultsetType resultsetType = queryServiceClient.query(fileReader);
            System.out.println("Result done");
            string4 = EcogridResultsetTransformer.toXMLString(resultsetType);
            System.out.println(string4);
            if (string3 != null) {
                System.out.println("Creating outputfile: " + string3);
                File file2 = new File(string3);
                FileWriter fileWriter = new FileWriter(file2);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                printWriter.println(string4);
                printWriter.flush();
                printWriter.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in main : " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

