/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database.pooling;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.database.ConnectionNotAvailableException;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.hsqldb.jdbc.jdbcDataSource;

public class HSQLDatabaseConnectionPool
implements DatabaseConnectionPoolInterface {
    public static Log log = LogFactory.getLog(HSQLDatabaseConnectionPool.class);
    private static final String CONFIG_NAME = "datamanager";
    private static ResourceBundle options = null;
    private static String databaseName = null;
    private static String user = null;
    private static String password = null;
    private static String databaseAdapterName = null;
    private static jdbcDataSource source = null;
    private static int connCount = 0;

    public HSQLDatabaseConnectionPool() {
        HSQLDatabaseConnectionPool.loadOptions();
        HSQLDatabaseConnectionPool.initPool();
    }

    private static void initPool() {
        source = new jdbcDataSource();
        source.setDatabase(databaseName);
        source.setUser(user);
        source.setPassword(password);
    }

    private static void loadOptions() {
        try {
            options = ResourceBundle.getBundle(CONFIG_NAME);
            databaseName = options.getString("dbName");
            user = options.getString("dbUser");
            password = options.getString("dbPassword");
            databaseAdapterName = options.getString("dbAdapter");
        }
        catch (Exception e) {
            System.out.println("Error in loading options: " + e.getMessage());
        }
    }

    @Override
    public String getDBAdapterName() {
        return databaseAdapterName;
    }

    @Override
    public Connection getConnection() throws SQLException, ConnectionNotAvailableException {
        Connection connection = null;
        try {
            connection = source.getConnection();
            ++connCount;
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        return connection;
    }

    @Override
    public boolean returnConnection(Connection conn) {
        boolean success = false;
        try {
            conn.close();
            success = true;
            --connCount;
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    public static void main(String[] arg) {
        HSQLDatabaseConnectionPool pool = new HSQLDatabaseConnectionPool();
        try {
            Connection conn = pool.getConnection();
            log.debug((Object)("conn=" + conn));
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ConnectionNotAvailableException e) {
            e.printStackTrace();
        }
    }
}

