/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.dao.DataSourceFactory;
import org.dataone.cn.dao.SystemMetadataDaoMetacatImpl;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.tidy.dao.SystemMetadataTidyDao;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class SystemMetadataTidyDaoImpl
implements SystemMetadataTidyDao {
    private static final Log log = LogFactory.getLog(SystemMetadataTidyDaoImpl.class);
    private JdbcTemplate jdbcTemplate;
    private SystemMetadataDaoMetacatImpl systemMetadataDao;
    private static final String UCSB_IDENTIFIER_TABLE = Settings.getConfiguration().getString("tidy.dao.ucsb.identifier");
    private static final String UCSB_SYSMETA_TABLE = Settings.getConfiguration().getString("tidy.dao.ucsb.systemmetadata");
    private static final String UCSB_SM_POLICY_TABLE = Settings.getConfiguration().getString("tidy.dao.ucsb.smreplpolicy");
    private static final String UCSB_SM_STATUS_TABLE = Settings.getConfiguration().getString("tidy.dao.ucsb.smreplstatus");
    private static final String UCSB_ACCESS_TABLE = Settings.getConfiguration().getString("tidy.dao.ucsb.access");
    private static final String ORC_IDENTIFIER_TABLE = Settings.getConfiguration().getString("tidy.dao.orc.identifier");
    private static final String ORC_SYSMETA_TABLE = Settings.getConfiguration().getString("tidy.dao.orc.systemmetadata");
    private static final String ORC_SM_POLICY_TABLE = Settings.getConfiguration().getString("tidy.dao.orc.smreplpolicy");
    private static final String ORC_SM_STATUS_TABLE = Settings.getConfiguration().getString("tidy.dao.orc.smreplstatus");
    private static final String ORC_ACCESS_TABLE = Settings.getConfiguration().getString("tidy.dao.orc.access");
    private static final String UNM_IDENTIFIER_TABLE = Settings.getConfiguration().getString("tidy.dao.unm.identifier");
    private static final String UNM_SYSMETA_TABLE = Settings.getConfiguration().getString("tidy.dao.unm.systemmetadata");
    private static final String UNM_SM_POLICY_TABLE = Settings.getConfiguration().getString("tidy.dao.unm.smreplpolicy");
    private static final String UNM_SM_STATUS_TABLE = Settings.getConfiguration().getString("tidy.dao.unm.smreplstatus");
    private static final String UNM_ACCESS_TABLE = Settings.getConfiguration().getString("tidy.dao.unm.access");
    private static final String MERGED_IDENTIFIER_TABLE = Settings.getConfiguration().getString("tidy.dao.merged.identifier");
    private static final String MERGED_SYSMETA_TABLE = Settings.getConfiguration().getString("tidy.dao.merged.systemmetadata");
    private static final String MERGED_SM_POLICY_TABLE = Settings.getConfiguration().getString("tidy.dao.merged.smreplpolicy");
    private static final String MERGED_SM_STATUS_TABLE = Settings.getConfiguration().getString("tidy.dao.merged.smreplstatus");
    private static final String MERGED_ACCESS_TABLE = Settings.getConfiguration().getString("tidy.dao.merged.access");
    protected static Map<String, String> unmTableMap = new HashMap<String, String>();
    protected static Map<String, String> orcTableMap = new HashMap<String, String>();
    protected static Map<String, String> ucsbTableMap = new HashMap<String, String>();
    protected static Map<String, String> mergedTableMap = new HashMap<String, String>();

    public SystemMetadataTidyDaoImpl() {
        this.jdbcTemplate = new JdbcTemplate((DataSource)DataSourceFactory.getPostgresDataSource());
        this.systemMetadataDao = new SystemMetadataDaoMetacatImpl((DataSource)DataSourceFactory.getPostgresDataSource());
    }

    public SystemMetadataTidyDaoImpl(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.systemMetadataDao = new SystemMetadataDaoMetacatImpl(dataSource);
    }

    @Override
    public List<Identifier> listIdentifiers() throws DataAccessException {
        ArrayList<Identifier> identifiers = new ArrayList();
        identifiers = this.jdbcTemplate.query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                StringBuffer sqlStatement = new StringBuffer();
                sqlStatement.append("SELECT guid FROM ");
                sqlStatement.append(UCSB_IDENTIFIER_TABLE);
                sqlStatement.append(" UNION ");
                sqlStatement.append("SELECT guid FROM ");
                sqlStatement.append(ORC_IDENTIFIER_TABLE);
                sqlStatement.append(" UNION ");
                sqlStatement.append("SELECT guid FROM ");
                sqlStatement.append(UNM_IDENTIFIER_TABLE);
                sqlStatement.append(" UNION ");
                sqlStatement.append("SELECT guid FROM ");
                sqlStatement.append(UCSB_SYSMETA_TABLE);
                sqlStatement.append(" UNION ");
                sqlStatement.append("SELECT guid FROM ");
                sqlStatement.append(ORC_SYSMETA_TABLE);
                sqlStatement.append(" UNION ");
                sqlStatement.append("SELECT guid FROM ");
                sqlStatement.append(UNM_SYSMETA_TABLE);
                sqlStatement.append(";");
                log.debug((Object)("listIdentifiers() SQL statement: " + sqlStatement.toString()));
                PreparedStatement statement = conn.prepareStatement(sqlStatement.toString());
                return statement;
            }
        }, (RowMapper)new IdentifierRowMapper());
        return identifiers;
    }

    @Override
    public Map<NodeReference, SystemMetadata> getSystemMetadata(Identifier identifier) throws DataAccessException {
        log.info((Object)"********** entering TidySysmetaDAOImpl getSysMeta ********");
        HashMap<NodeReference, SystemMetadata> sysMetaMap = new HashMap<NodeReference, SystemMetadata>();
        NodeReference ucsbNodeId = new NodeReference();
        ucsbNodeId.setValue(Settings.getConfiguration().getString("tidy.dao.ucsb.nodeid"));
        SystemMetadata ucsbSysMeta = this.systemMetadataDao.getSystemMetadata(identifier, ucsbTableMap);
        NodeReference orcNodeId = new NodeReference();
        orcNodeId.setValue(Settings.getConfiguration().getString("tidy.dao.orc.nodeid"));
        SystemMetadata orcSysMeta = this.systemMetadataDao.getSystemMetadata(identifier, orcTableMap);
        NodeReference unmNodeId = new NodeReference();
        unmNodeId.setValue(Settings.getConfiguration().getString("tidy.dao.unm.nodeid"));
        SystemMetadata unmSysMeta = this.systemMetadataDao.getSystemMetadata(identifier, unmTableMap);
        if (ucsbSysMeta != null) {
            sysMetaMap.put(ucsbNodeId, ucsbSysMeta);
        }
        if (orcSysMeta != null) {
            sysMetaMap.put(orcNodeId, orcSysMeta);
        }
        if (unmSysMeta != null) {
            sysMetaMap.put(unmNodeId, unmSysMeta);
        }
        log.info((Object)("TidySysmetaDAOImpl available sysmetas for pid: " + identifier.getValue() + " : " + sysMetaMap.size()));
        if (sysMetaMap.isEmpty()) {
            log.error((Object)("TidySysmetaDAOimpl: No SystemMetadata available for pid: " + identifier.getValue()));
            StringBuffer sb = new StringBuffer();
            if (ucsbTableMap != null) {
                for (Map.Entry<String, String> n : ucsbTableMap.entrySet()) {
                    sb.append(String.format("%s=%s: ", n.getKey(), n.getValue()));
                }
                log.warn((Object)("(sample table map: " + sb.toString()));
            } else {
                log.error((Object)"ucsb tablemap is null!!");
            }
        } else if (log.isDebugEnabled()) {
            for (Map.Entry n : sysMetaMap.entrySet()) {
                log.debug((Object)String.format("%s = %s", ((NodeReference)n.getKey()).getValue(), n.getValue()));
            }
        }
        return sysMetaMap;
    }

    @Override
    public void saveSystemMetadata(SystemMetadata systemMetadata) throws DataAccessException {
        this.systemMetadataDao.saveSystemMetadata(systemMetadata, mergedTableMap);
    }

    static {
        unmTableMap.put("identifier", UNM_IDENTIFIER_TABLE);
        unmTableMap.put("systemmetadata", UNM_SYSMETA_TABLE);
        unmTableMap.put("smreplicationpolicy", UNM_SM_POLICY_TABLE);
        unmTableMap.put("smreplicationstatus", UNM_SM_STATUS_TABLE);
        unmTableMap.put("xml_access", UNM_ACCESS_TABLE);
        orcTableMap.put("identifier", ORC_IDENTIFIER_TABLE);
        orcTableMap.put("systemmetadata", ORC_SYSMETA_TABLE);
        orcTableMap.put("smreplicationpolicy", ORC_SM_POLICY_TABLE);
        orcTableMap.put("smreplicationstatus", ORC_SM_STATUS_TABLE);
        orcTableMap.put("xml_access", ORC_ACCESS_TABLE);
        ucsbTableMap.put("identifier", UCSB_IDENTIFIER_TABLE);
        ucsbTableMap.put("systemmetadata", UCSB_SYSMETA_TABLE);
        ucsbTableMap.put("smreplicationpolicy", UCSB_SM_POLICY_TABLE);
        ucsbTableMap.put("smreplicationstatus", UCSB_SM_STATUS_TABLE);
        ucsbTableMap.put("xml_access", UCSB_ACCESS_TABLE);
        mergedTableMap.put("identifier", MERGED_IDENTIFIER_TABLE);
        mergedTableMap.put("systemmetadata", MERGED_SYSMETA_TABLE);
        mergedTableMap.put("smreplicationpolicy", MERGED_SM_POLICY_TABLE);
        mergedTableMap.put("smreplicationstatus", MERGED_SM_STATUS_TABLE);
        mergedTableMap.put("xml_access", MERGED_ACCESS_TABLE);
    }

    public static final class IdentifierRowMapper
    implements RowMapper<Identifier> {
        public Identifier mapRow(ResultSet resultSet, int rowNumber) throws SQLException {
            Identifier identifier = new Identifier();
            identifier.setValue(resultSet.getString("guid"));
            return identifier;
        }
    }
}

