/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.dao;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.dataone.tidy.dao.MergeStatus;
import org.hibernate.annotations.Index;
import org.jibx.runtime.JiBXException;

@Entity
@Table(name="merge_result")
public class MergeResult
implements Serializable {
    private static final long serialVersionUID = 995840092901314022L;
    private static final Long RUN_ID = Settings.getConfiguration().getLong("tidy.run.id", 999L);
    @Transient
    private static final Log log = LogFactory.getLog(MergeResult.class);
    @Transient
    private final FastDateFormat format = FastDateFormat.getInstance((String)"MM/dd/yyyy:HH:mm:ss:SS");
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Index(name="index_pid")
    @Column(columnDefinition="TEXT", nullable=false)
    private String pid;
    @Index(name="index_run")
    @Column
    private Long runId = RUN_ID;
    private Date mergeDate;
    @Column(columnDefinition="TEXT")
    private String mnSystemMetadataStr;
    @Column(columnDefinition="TEXT")
    private String mergedSystemMetadataStr;
    @Column(columnDefinition="TEXT")
    private String processingException;
    @Column(nullable=false)
    private String mergeStatusStr;
    @Column
    private String review;
    @Column
    private String authMN;

    public MergeResult() {
    }

    public MergeResult(SystemMetadata mergedSystemMetadata, SystemMetadata mnSystemMetadata, MergeStatus status) {
        this.mergedSystemMetadataStr = MergeResult.marshalSystemMetadata(mergedSystemMetadata);
        this.mnSystemMetadataStr = MergeResult.marshalSystemMetadata(mnSystemMetadata);
        this.pid = mergedSystemMetadata.getIdentifier().getValue();
        this.setMergeStatus(status);
    }

    public MergeResult(String pidValue, MergeStatus status) {
        this.pid = pidValue;
        this.setMergeStatus(status);
        this.mergeDate = new Date(System.currentTimeMillis());
    }

    @Transient
    private SystemMetadata unMarshalSystemMetadata(String systemMetadataString) {
        ByteArrayInputStream is = new ByteArrayInputStream(systemMetadataString.getBytes());
        SystemMetadata smd = null;
        try {
            smd = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)is);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (JiBXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return smd;
    }

    @Transient
    public static String marshalSystemMetadata(SystemMetadata smd) {
        if (smd == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            TypeMarshaller.marshalTypeToOutputStream((Object)smd, (OutputStream)os);
        }
        catch (JiBXException jibxEx) {
            log.error((Object)jibxEx.getMessage(), (Throwable)jibxEx);
        }
        catch (IOException ioEx) {
            log.error((Object)ioEx.getMessage(), (Throwable)ioEx);
        }
        String sysMetaStr = null;
        try {
            sysMetaStr = os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
        }
        return sysMetaStr;
    }

    public Long getId() {
        return this.id;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public Date getMergeDate() {
        return this.mergeDate;
    }

    @Transient
    public String getMergeDateString() {
        return this.format.format(this.mergeDate);
    }

    public void setMergeDate(Date mergeDate) {
        this.mergeDate = mergeDate;
    }

    public String getMergedSystemMetadataStr() {
        return this.mergedSystemMetadataStr;
    }

    public void setMergedSystemMetadataStr(String systemMetadata) {
        this.mergedSystemMetadataStr = systemMetadata;
    }

    public String getMnSystemMetadataStr() {
        return this.mnSystemMetadataStr;
    }

    public void setMnSystemMetadataStr(String mnSystemMetadataStr) {
        this.mnSystemMetadataStr = mnSystemMetadataStr;
    }

    public SystemMetadata getMergedSystemMetadata() {
        if (this.mergedSystemMetadataStr == null) {
            return null;
        }
        return this.unMarshalSystemMetadata(this.mergedSystemMetadataStr);
    }

    public SystemMetadata getMnSystemMetadata() {
        if (this.mnSystemMetadataStr == null) {
            return null;
        }
        return this.unMarshalSystemMetadata(this.mnSystemMetadataStr);
    }

    public void setProcessingException(String exception) {
        this.processingException = exception;
    }

    public String getProcessingException() {
        return this.processingException;
    }

    public void setMergeStatusStr(String status) {
        this.mergeStatusStr = status;
    }

    public String getMergeStatusStr() {
        return this.mergeStatusStr;
    }

    @Transient
    public void setMergeStatus(MergeStatus status) {
        this.mergeStatusStr = status.toString();
    }

    @Transient
    public MergeStatus getMergeStatus() {
        return MergeStatus.valueOf(this.mergeStatusStr);
    }

    @Transient
    public void setMnSystemMetadata(SystemMetadata sysmeta) {
        this.setMnSystemMetadataStr(MergeResult.marshalSystemMetadata(sysmeta));
    }

    @Transient
    public void setMergedSystemMetadata(SystemMetadata sysmeta) {
        this.setMergedSystemMetadataStr(MergeResult.marshalSystemMetadata(sysmeta));
    }

    public Long getRunId() {
        return this.runId;
    }

    public void setRunId(Long runId) {
        this.runId = runId;
    }

    public String getReview() {
        return this.review;
    }

    public void setReview(String review) {
        this.review = review;
    }

    public String getAuthoritativeMemberNode() {
        return this.authMN;
    }

    public void setAuthoritativeMemberNode(String memberNode) {
        this.authMN = memberNode;
    }

    public String toString() {
        return "MergeResult [id=" + this.id + ", pid=" + this.pid + ", mergeDate=" + this.getMergeDateString() + ", runId=" + this.runId + ", status=" + this.mergeStatusStr + ", authMN=" + this.authMN + ", exception='" + this.getProcessingException() + "']";
    }
}

