/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dataone.client.MNode;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.impl.v1.NodeRegistryService;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.tidy.InclusionsFilter;
import org.dataone.tidy.Main;
import org.dataone.tidy.dao.MergeResult;
import org.dataone.tidy.dao.MergeResultRepository;
import org.dataone.tidy.dao.MergeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PostMerge {
    private static Logger logger = LoggerFactory.getLogger(Main.class);
    private static final Logger successLogger = LoggerFactory.getLogger(PostMerge.class);
    private static final Logger exclusionLogger = LoggerFactory.getLogger(InclusionsFilter.class);
    private static final int PAGE_SIZE = 1000;
    private static final Long RUN_ID = Settings.getConfiguration().getLong("tidy.run.id", 999L);
    private MergeResultRepository mergeResultRepository;
    private InclusionsFilter inclusionsFilter;
    private NodeRegistryService nodeRegistryService;
    private Map<NodeReference, Node> nodeHashMap = new HashMap<NodeReference, Node>();

    private PostMerge() {
    }

    public PostMerge(MergeResultRepository mergeResultRepository) {
        this.mergeResultRepository = mergeResultRepository;
        this.inclusionsFilter = InclusionsFilter.getInstance();
        this.nodeRegistryService = new NodeRegistryService();
    }

    public void postMerge() {
        PageRequest pageRequest = new PageRequest(0, 1000, new Sort(Sort.Direction.ASC, new String[]{"id"}));
        Page pagedResults = this.mergeResultRepository.findByMergeStatusStrAndRunId(MergeStatus.SUCCESS.toString(), RUN_ID, (Pageable)pageRequest);
        this.processPageOfMergeResults(pagedResults.getContent());
        while (pagedResults.hasNextPage()) {
            pagedResults = this.mergeResultRepository.findAll(pagedResults.nextPageable());
            this.processPageOfMergeResults(pagedResults.getContent());
        }
    }

    private void processPageOfMergeResults(List<MergeResult> results) {
        for (MergeResult result : results) {
            SystemMetadata mergedSystemMetadata = result.getMergedSystemMetadata();
            try {
                this.markMergedPidsUpdatedForMN(mergedSystemMetadata);
            }
            catch (PostMergeNullException ex) {
                logger.warn("MergeResult has a null systemMetadata " + result.getPid() + " because " + result.getReview());
            }
        }
    }

    private void evictAndGetMergedPids(Identifier mergedPid) {
        HazelcastClientFactory.getSystemMetadataMap().evict((Object)mergedPid);
        HazelcastClientFactory.getSystemMetadataMap().get((Object)mergedPid);
    }

    private void markMergedPidsUpdatedForMN(SystemMetadata mergedSystemMetadata) throws PostMergeNullException {
        try {
            if (mergedSystemMetadata != null && this.inclusionsFilter.shouldInclude(mergedSystemMetadata.getIdentifier(), mergedSystemMetadata.getAuthoritativeMemberNode()).booleanValue()) {
                List prevReplicaList = mergedSystemMetadata.getReplicaList();
                Session session = null;
                for (Replica replica : prevReplicaList) {
                    try {
                        Node node;
                        if (!this.nodeHashMap.containsKey(replica.getReplicaMemberNode())) {
                            this.nodeHashMap.put(replica.getReplicaMemberNode(), this.nodeRegistryService.getNode(replica.getReplicaMemberNode()));
                        }
                        if (!(node = this.nodeHashMap.get(replica.getReplicaMemberNode())).getType().equals((Object)NodeType.MN)) continue;
                        boolean isTier3 = false;
                        for (Service service : node.getServices().getServiceList()) {
                            if (!service.getName().equals("MNStorage") || !service.getAvailable().booleanValue()) continue;
                            isTier3 = true;
                            break;
                        }
                        if (!isTier3) continue;
                        if (this.inclusionsFilter.shouldInclude(mergedSystemMetadata.getIdentifier(), node.getIdentifier()).booleanValue()) {
                            try {
                                String mnUrl = node.getBaseURL();
                                MNode mnNode = new MNode(mnUrl);
                                mnNode.systemMetadataChanged(session, mergedSystemMetadata.getIdentifier(), mergedSystemMetadata.getSerialVersion().longValue(), mergedSystemMetadata.getDateSysMetadataModified());
                                successLogger.info(mergedSystemMetadata.getIdentifier().getValue());
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    logger.error("Thread Interrupted while sleeping after system metadata changed call.");
                                }
                            }
                            catch (BaseException be) {
                                logger.error("Caught base exception when calling system metadata changed for MN: " + node.getName() + " and pid: " + mergedSystemMetadata.getIdentifier().getValue(), (Throwable)be);
                            }
                            continue;
                        }
                        exclusionLogger.info(node.getIdentifier().getValue() + " " + mergedSystemMetadata.getIdentifier().getValue());
                    }
                    catch (ServiceFailure ex) {
                        logger.error("Caught ServiceFailure while processing PID: " + mergedSystemMetadata.getIdentifier().getValue(), (Throwable)ex);
                    }
                    catch (NotFound ex) {
                        logger.error("Caught NotFound while processing PID: " + mergedSystemMetadata.getIdentifier().getValue(), (Throwable)ex);
                    }
                }
            } else {
                if (mergedSystemMetadata == null) {
                    throw new PostMergeNullException();
                }
                logger.warn("System metadata for pid: " + mergedSystemMetadata.getIdentifier().getValue() + " is not included in system metadata map.");
            }
        }
        catch (ServiceFailure ex) {
            logger.error("Caught ServiceFailure when calling inclusionsFilter.shouldInclude  for PID: " + mergedSystemMetadata.getIdentifier().getValue(), (Throwable)ex);
        }
        catch (NotFound ex) {
            logger.error("Caught NotFound when calling inclusionsFilter.shouldInclude  for PID: " + mergedSystemMetadata.getIdentifier().getValue(), (Throwable)ex);
        }
    }

    public class PostMergeNullException
    extends Exception {
    }
}

