/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpStage;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.GNode;
import com.hp.hpl.jena.sparql.util.GraphList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class PropertyFunctionGenerator {
    public static Op compile(BasicPattern pattern, Context context) {
        if (pattern.isEmpty()) {
            return new OpBGP(pattern);
        }
        boolean doingMagicProperties = context.isTrue(ARQ.enablePropertyFunctions);
        if (!doingMagicProperties) {
            return new OpBGP(pattern);
        }
        PropertyFunctionRegistry registry = PropertyFunctionGenerator.chooseRegistry(context);
        ArrayList propertyFunctionTriples = new ArrayList();
        BasicPattern triples = new BasicPattern(pattern);
        PropertyFunctionGenerator.findPropertyFunctions(context, pattern, registry, propertyFunctionTriples);
        if (propertyFunctionTriples.size() == 0) {
            return new OpBGP(pattern);
        }
        HashMap pfInvocations = new HashMap();
        PropertyFunctionGenerator.findPropertyFunctionArgs(context, triples, propertyFunctionTriples, pfInvocations);
        Op op = PropertyFunctionGenerator.makeStages(triples, pfInvocations);
        return op;
    }

    private static void findPropertyFunctions(Context context, BasicPattern pattern, PropertyFunctionRegistry registry, List propertyFunctionTriples) {
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (!PropertyFunctionGenerator.isMagicProperty(registry, t)) continue;
            propertyFunctionTriples.add(t);
        }
    }

    private static void findPropertyFunctionArgs(Context context, BasicPattern triples, List propertyFunctionTriples, Map pfInvocations) {
        Iterator iter = propertyFunctionTriples.iterator();
        while (iter.hasNext()) {
            Triple pf = (Triple)iter.next();
            PropertyFunctionInstance pfi = PropertyFunctionGenerator.magicProperty(context, pf, triples);
            pfInvocations.put(pf, pfi);
        }
    }

    private static Op makeStages(BasicPattern triples, Map pfInvocations) {
        Op op = null;
        BasicPattern pattern = null;
        ListIterator iter = triples.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (pfInvocations.containsKey(t)) {
                op = PropertyFunctionGenerator.flush(pattern, op);
                pattern = null;
                PropertyFunctionInstance pfi = (PropertyFunctionInstance)pfInvocations.get(t);
                OpProcedure opProc = new OpProcedure(t.getPredicate(), pfi.getSubjectArgList(), pfi.getObjectArgList(), op);
                op = opProc;
                continue;
            }
            if (pattern == null) {
                pattern = new BasicPattern();
            }
            pattern.add(t);
        }
        op = PropertyFunctionGenerator.flush(pattern, op);
        return op;
    }

    private static Op flush(BasicPattern pattern, Op op) {
        if (pattern == null || pattern.isEmpty()) {
            if (op == null) {
                return OpTable.unit();
            }
            return op;
        }
        OpBGP opBGP = new OpBGP(pattern);
        if (op == null) {
            return opBGP;
        }
        return OpStage.create(op, opBGP);
    }

    private static PropertyFunctionRegistry chooseRegistry(Context context) {
        PropertyFunctionRegistry registry = PropertyFunctionRegistry.get(context);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        return registry;
    }

    private static boolean isMagicProperty(PropertyFunctionRegistry registry, Triple pfTriple) {
        if (!pfTriple.getPredicate().isURI()) {
            return false;
        }
        return registry.manages(pfTriple.getPredicate().getURI());
    }

    private static PropertyFunctionInstance magicProperty(Context context, Triple pfTriple, BasicPattern triples) {
        ArrayList listTriples = new ArrayList();
        GNode sGNode = new GNode(triples, pfTriple.getSubject());
        GNode oGNode = new GNode(triples, pfTriple.getObject());
        List sList = null;
        List oList = null;
        if (GraphList.isListNode(sGNode)) {
            sList = GraphList.members(sGNode);
            GraphList.allTriples(sGNode, listTriples);
        }
        if (GraphList.isListNode(oGNode)) {
            oList = GraphList.members(oGNode);
            GraphList.allTriples(oGNode, listTriples);
        }
        PropFuncArg subjArgs = new PropFuncArg(sList, pfTriple.getSubject());
        PropFuncArg objArgs = new PropFuncArg(oList, pfTriple.getObject());
        PropertyFunctionInstance pfi = new PropertyFunctionInstance(subjArgs, pfTriple.getPredicate(), objArgs);
        triples.getList().removeAll(listTriples);
        return pfi;
    }

    private static class PropertyFunctionInstance {
        Node predicate;
        PropFuncArg subjArgs;
        PropFuncArg objArgs;

        PropertyFunctionInstance(PropFuncArg sArgs, Node predicate, PropFuncArg oArgs) {
            this.subjArgs = sArgs;
            this.predicate = predicate;
            this.objArgs = oArgs;
        }

        ExprList argList() {
            ExprList exprList = new ExprList();
            PropertyFunctionInstance.argList(exprList, this.subjArgs);
            PropertyFunctionInstance.argList(exprList, this.objArgs);
            return exprList;
        }

        PropFuncArg getSubjectArgList() {
            return this.subjArgs;
        }

        PropFuncArg getObjectArgList() {
            return this.objArgs;
        }

        private static void argList(ExprList exprList, PropFuncArg pfArg) {
            if (pfArg.isNode()) {
                Node n = pfArg.getArg();
                Expr expr = ExprUtils.nodeToExpr(n);
                exprList.add(expr);
                return;
            }
            Iterator iter = pfArg.getArgList().iterator();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                Expr expr = ExprUtils.nodeToExpr(n);
                exprList.add(expr);
            }
        }
    }
}

