/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.ontology;

import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.annotator.generator.AnnotationGenerator;
import org.dataone.configuration.Settings;

public class MeasurementTypeGenerator {
    private static Log log = LogFactory.getLog(MeasurementTypeGenerator.class);
    public static String ecso = "http://purl.dataone.org/odo/d1-ECSO.owl";
    public static String ecsoPrefix = "http://purl.dataone.org/odo/ECSO_";
    public static String taxaPrefix = "http://purl.dataone.org/odo/TAXA_";
    public static String envoPrefix = "http://purl.obolibrary.org/obo/ENVO_";
    public static String patoPrefix = "http://purl.obolibrary.org/obo/PATO_";
    public static String uoPrefix = "http://purl.obolibrary.org/obo/UO_";
    private OntModel ecsoModel = null;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private int classId;
    private Map<String, OntClass> allConcepts = new HashMap<String, OntClass>();
    private OntModel m = null;
    private Property rdfsLabel = null;
    private ObjectProperty measuresCharacteristic = null;
    private ObjectProperty measuresEntity = null;
    private OntClass entityClass = null;
    private OntClass characteristicClass = null;
    private OntClass measurementTypeClass = null;

    public MeasurementTypeGenerator() {
        this.namespaces.put("ecso", ecsoPrefix);
        this.namespaces.put("taxa", taxaPrefix);
        this.namespaces.put("envo", envoPrefix);
        this.namespaces.put("pato", patoPrefix);
        this.namespaces.put("uo", uoPrefix);
        this.namespaces.put("oboe", AnnotationGenerator.oboe);
        this.namespaces.put("oboe-core", AnnotationGenerator.oboe_core);
        this.namespaces.put("oboe-characteristics", AnnotationGenerator.oboe_characteristics);
        this.ecsoModel = ModelFactory.createOntologyModel();
        this.ecsoModel.read(ecso);
        AnnotationGenerator.initializeCache();
        this.m = ModelFactory.createOntologyModel();
        Ontology ont = this.m.createOntology(ecso);
        ont.addImport(this.m.createResource(AnnotationGenerator.oboe));
        this.m.addSubModel(OntDocumentManager.getInstance().getModel(AnnotationGenerator.oboe));
        this.rdfsLabel = this.ecsoModel.getProperty(AnnotationGenerator.rdfs + "label");
        this.measuresCharacteristic = this.ecsoModel.getObjectProperty(AnnotationGenerator.oboe_core + "measuresCharacteristic");
        this.measuresEntity = this.ecsoModel.getObjectProperty(AnnotationGenerator.oboe_core + "measuresEntity");
        this.entityClass = this.ecsoModel.getOntClass(AnnotationGenerator.oboe_core + "Entity");
        this.characteristicClass = this.ecsoModel.getOntClass(AnnotationGenerator.oboe_core + "Characteristic");
        this.measurementTypeClass = this.ecsoModel.getOntClass(AnnotationGenerator.oboe_core + "MeasurementType");
        this.classId = Settings.getConfiguration().getInt("annotator.ontology.classId");
        ExtendedIterator classIter = this.ecsoModel.listNamedClasses();
        while (classIter.hasNext()) {
            OntClass cls = (OntClass)classIter.next();
            String label = cls.getLabel(null);
            if (label == null) {
                label = cls.getLocalName();
            }
            log.trace((Object)("Initializing class label: " + label));
            this.allConcepts.put(label, cls);
        }
    }

    public boolean isMeasurementTypeSubclass(String classURI) {
        OntClass superClass = this.getMeasurementTypeClass();
        Resource subclass = superClass.getModel().getResource(classURI);
        boolean isSubclass = false;
        try {
            isSubclass = superClass.hasSubClass(subclass);
        }
        catch (ConversionException ce) {
            log.warn((Object)("Skipping unknown subclass: " + classURI + " -- " + ce.getMessage()));
            return false;
        }
        return isSubclass;
    }

    public OntClass generateMeasurementType(String entityLabel, String characteristicLabel) {
        String entityUri;
        String measurementTypeLabel = this.getFragment(entityLabel) + " " + this.getFragment(characteristicLabel);
        String existingType = this.lookupConcept("ecso:" + measurementTypeLabel);
        if (existingType != null) {
            OntClass mt = this.m.createClass(existingType);
            return mt;
        }
        OntClass entity = null;
        OntClass characteristic = null;
        String characteristicUri = this.lookupConcept(characteristicLabel);
        if (characteristicUri == null) {
            characteristic = this.generateCharacteristic(characteristicLabel);
            if (characteristic == null) {
                return null;
            }
            characteristicUri = characteristic.getURI();
        }
        if ((entityUri = this.lookupConcept(entityLabel)) == null) {
            entity = this.generateEntity(entityLabel);
            if (entity == null) {
                return null;
            }
            entityUri = entity.getURI();
        }
        String partialUri = String.format("%8s", this.classId++).replace(' ', '0');
        String uri = ecsoPrefix + partialUri;
        OntClass mt = this.m.createClass(uri);
        mt.addProperty(this.rdfsLabel, measurementTypeLabel);
        mt.setSuperClass((Resource)this.measurementTypeClass);
        if (characteristic == null) {
            characteristic = this.getConcept(characteristicUri);
        }
        SomeValuesFromRestriction characteristicRestriction = this.m.createSomeValuesFromRestriction(null, (Property)this.measuresCharacteristic, (Resource)characteristic);
        mt.addSuperClass((Resource)characteristicRestriction);
        if (entity == null) {
            entity = this.getConcept(entityUri);
        }
        SomeValuesFromRestriction entityRestriction = this.m.createSomeValuesFromRestriction(null, (Property)this.measuresEntity, (Resource)entity);
        mt.addSuperClass((Resource)entityRestriction);
        return mt;
    }

    public OntClass generateEntity(String entityString) {
        String entityLabel = this.getFragment(entityString);
        String entityNamespace = this.getNamespace(entityString);
        if (entityNamespace == null) {
            log.warn((Object)("Namespace is null for: " + entityString));
            return null;
        }
        String partialUri = String.format("%8s", this.classId++).replace(' ', '0');
        String uri = entityNamespace + partialUri;
        log.debug((Object)("Generating ENTITY: " + uri));
        OntClass entitySubclass = this.m.createClass(uri);
        entitySubclass.addProperty(this.rdfsLabel, entityLabel);
        entitySubclass.setSuperClass((Resource)this.entityClass);
        this.allConcepts.put(entitySubclass.getLabel(null), entitySubclass);
        return entitySubclass;
    }

    public OntClass generateCharacteristic(String characteristicString) {
        String characteristicLabel = this.getFragment(characteristicString);
        String characteristicNamespace = this.getNamespace(characteristicString);
        if (characteristicNamespace == null) {
            log.warn((Object)("Namespace is null for: " + characteristicString));
            return null;
        }
        String partialUri = String.format("%8s", this.classId++).replace(' ', '0');
        String uri = characteristicNamespace + partialUri;
        log.debug((Object)("Generating CHARACTERISTIC: " + uri));
        OntClass characteristicSubclass = this.m.createClass(uri);
        characteristicSubclass.addProperty(this.rdfsLabel, characteristicLabel);
        characteristicSubclass.setSuperClass((Resource)this.characteristicClass);
        this.allConcepts.put(characteristicSubclass.getLabel(null), characteristicSubclass);
        return characteristicSubclass;
    }

    public String getModelAsString() {
        StringWriter sw = new StringWriter();
        this.m.write((Writer)sw, "RDF/XML");
        String result = sw.toString();
        return result;
    }

    private String getNamespace(String fullLabel) {
        String prefix = fullLabel.split(":")[0];
        return this.namespaces.get(prefix);
    }

    private String getFragment(String fullLabel) {
        String fragment = fullLabel.split(":")[1];
        return fragment;
    }

    public OntClass getMeasurementTypeClass() {
        return this.measurementTypeClass;
    }

    public void setMeasurementTypeClass(OntClass measurementTypeClass) {
        this.measurementTypeClass = measurementTypeClass;
    }

    public OntClass getConcept(String uri) {
        OntClass concept = null;
        concept = this.m.getOntClass(uri);
        if (concept == null) {
            concept = this.ecsoModel.getOntClass(uri);
        }
        return concept;
    }

    public String lookupConcept(String fullLabel) {
        String concept = null;
        OntClass existingConcept = this.allConcepts.get(this.getFragment(fullLabel));
        if (existingConcept != null) {
            concept = existingConcept.getURI();
        }
        return concept;
    }

    private String lookupConcept(String fullLabel, OntModel model) {
        String concept = null;
        String prefix = this.getNamespace(fullLabel);
        String fragment = this.getFragment(fullLabel);
        String uri = prefix + fragment;
        Resource resource = ResourceFactory.createResource((String)uri);
        if (model.containsResource((RDFNode)resource)) {
            return uri;
        }
        String queryString = "prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nselect ?class where {\n  ?class rdfs:label \"" + fragment + "\"\n" + "}";
        ResultSet results = QueryExecutionFactory.create((String)queryString, (Model)model).execSelect();
        if (results.hasNext()) {
            QuerySolution solution = results.nextSolution();
            concept = solution.get("class").toString();
            log.debug((Object)("found matching concept: " + concept));
            return concept;
        }
        return concept;
    }

    public static void main(String[] args) {
        MeasurementTypeGenerator mtg = new MeasurementTypeGenerator();
        OntClass measurementType = mtg.generateMeasurementType("ecso:Tree", "oboe-characteristics:Count");
        OntClass entity = mtg.generateEntity("taxa:Cyperus");
        String rdf = mtg.getModelAsString();
        System.out.println(rdf);
    }

    public String generateTypes(String pidFile) throws Exception {
        URL url = new URL(pidFile);
        InputStream inputStream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        CSVParser records = CSVFormat.TDF.withHeader(new String[0]).parse((Reader)reader);
        int count = 0;
        for (CSVRecord record : records) {
            String entityLabel = record.get("Entity");
            String characteristicLabel = record.get("Characteristic");
            String class_id_int = record.get("class_id_int");
            if (class_id_int != null && class_id_int.length() > 0 || entityLabel == null || entityLabel.length() == 0 || characteristicLabel == null || characteristicLabel.length() == 0) continue;
            String rowValue = this.getFragment(entityLabel) + " " + this.getFragment(characteristicLabel);
            log.debug((Object)("Processing row: " + rowValue));
            if (this.allConcepts.containsKey(rowValue)) {
                log.debug((Object)"Skipping duplicate row");
                continue;
            }
            OntClass mt = this.generateMeasurementType(entityLabel, characteristicLabel);
            if (mt != null) {
                String uri = mt.getURI();
                String generatedClassIdInt = uri.split("_")[1];
                generatedClassIdInt = generatedClassIdInt.replaceFirst("^0+(?!$)", "");
                log.debug((Object)("Generated MeasurementType: \t" + generatedClassIdInt + "\t" + uri + "\t" + mt.getLabel(null) + "\t" + entityLabel + "\t" + characteristicLabel));
                this.allConcepts.put(rowValue, mt);
                ++count;
                continue;
            }
            log.debug((Object)("could not generate MeasurementType for row: " + rowValue));
        }
        log.debug((Object)("Generated class count: " + count));
        String rdf = this.getModelAsString();
        System.out.println(rdf);
        return rdf;
    }
}

