/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Map;

public class TriplePattern
implements ClauseEntry {
    protected Node subject;
    protected Node predicate;
    protected Node object;

    public TriplePattern(Node subject, Node predicate, Node object) {
        this.subject = TriplePattern.normalize(subject);
        this.predicate = TriplePattern.normalize(predicate);
        this.object = TriplePattern.normalize(object);
    }

    @Deprecated
    public TriplePattern(TripleMatch match) {
        this.subject = TriplePattern.normalize(match.getMatchSubject());
        this.predicate = TriplePattern.normalize(match.getMatchPredicate());
        this.object = TriplePattern.normalize(match.getMatchObject());
    }

    public TriplePattern(Triple match) {
        this.subject = TriplePattern.normalize(match.getSubject());
        this.predicate = TriplePattern.normalize(match.getPredicate());
        this.object = TriplePattern.normalize(match.getObject());
    }

    public Node getObject() {
        return this.object;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public Node getSubject() {
        return this.subject;
    }

    public Triple asTripleMatch() {
        return Triple.createMatch(TriplePattern.toMatch(this.subject), TriplePattern.toMatch(this.predicate), TriplePattern.toMatch(this.object));
    }

    public Triple asTriple() {
        return new Triple(this.subject, this.predicate, this.object);
    }

    public boolean compatibleWith(TriplePattern pattern) {
        boolean ok;
        boolean bl = ok = this.subject.isVariable() || pattern.subject.isVariable() || this.subject.equals(pattern.subject);
        if (!ok) {
            return false;
        }
        boolean bl2 = ok = this.predicate.isVariable() || pattern.predicate.isVariable() || this.predicate.equals(pattern.predicate);
        if (!ok) {
            return false;
        }
        if (this.object.isVariable() || pattern.object.isVariable()) {
            return true;
        }
        if (Functor.isFunctor(this.object) && Functor.isFunctor(pattern.object)) {
            Functor functor = (Functor)this.object.getLiteralValue();
            Functor pFunctor = (Functor)pattern.object.getLiteralValue();
            return functor.getName().equals(pFunctor.getName()) && functor.getArgs().length == pFunctor.getArgs().length;
        }
        return this.object.sameValueAs(pattern.object);
    }

    public boolean variantOf(TriplePattern pattern) {
        Map<Node, Node> vmap = CollectionFactory.createHashedMap();
        if (!this.variantOf(this.subject, pattern.subject, vmap)) {
            return false;
        }
        if (!this.variantOf(this.predicate, pattern.predicate, vmap)) {
            return false;
        }
        if (Functor.isFunctor(this.object) && Functor.isFunctor(pattern.object)) {
            Node[] pargs;
            Functor functor = (Functor)this.object.getLiteralValue();
            Functor pFunctor = (Functor)pattern.object.getLiteralValue();
            if (!functor.getName().equals(pFunctor.getName())) {
                return false;
            }
            Node[] args = functor.getArgs();
            if (args.length != (pargs = pFunctor.getArgs()).length) {
                return false;
            }
            for (int i = 0; i < args.length; ++i) {
                if (this.variantOf(args[i], pargs[i], vmap)) continue;
                return false;
            }
            return true;
        }
        return this.variantOf(this.object, pattern.object, vmap);
    }

    private boolean variantOf(Node n, Node p, Map<Node, Node> vmap) {
        if (n instanceof Node_RuleVariable) {
            if (p instanceof Node_RuleVariable) {
                Node nMatch = vmap.get(n);
                if (nMatch == null) {
                    vmap.put(n, p);
                    return true;
                }
                return nMatch == p;
            }
            return false;
        }
        return n.sameValueAs(p);
    }

    public boolean isLegal() {
        if (this.subject.isLiteral() || this.predicate.isLiteral()) {
            return false;
        }
        if (Functor.isFunctor(this.subject)) {
            return false;
        }
        if (Functor.isFunctor(this.object)) {
            Node[] args;
            for (Node arg : args = ((Functor)this.object.getLiteralValue()).getArgs()) {
                if (!Functor.isFunctor(arg)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean subsumes(TriplePattern arg) {
        return !(!this.subject.isVariable() && !this.subject.equals(arg.subject) || !this.predicate.isVariable() && !this.predicate.equals(arg.predicate) || !this.object.isVariable() && !this.object.equals(arg.object));
    }

    public boolean isGround() {
        if (this.subject.isVariable() || this.predicate.isVariable() || this.object.isVariable()) {
            return false;
        }
        if (Functor.isFunctor(this.object)) {
            return ((Functor)this.object.getLiteralValue()).isGround();
        }
        return true;
    }

    public String toString() {
        return TriplePattern.simplePrintString(this.subject) + " @" + TriplePattern.simplePrintString(this.predicate) + " " + TriplePattern.simplePrintString(this.object);
    }

    public static String simplePrintString(Triple t) {
        return TriplePattern.simplePrintString(t.getSubject()) + " @" + TriplePattern.simplePrintString(t.getPredicate()) + " " + TriplePattern.simplePrintString(t.getObject());
    }

    public static String simplePrintString(Node n) {
        if (n instanceof Node_URI) {
            String uri = n.getURI();
            int split = uri.lastIndexOf(35);
            if (split == -1 && (split = uri.lastIndexOf(47)) == -1) {
                split = -1;
            }
            String ns = uri.substring(0, split + 1);
            String prefix = "";
            if (ns.equals(RDF.getURI())) {
                prefix = "rdf:";
            } else if (ns.equals(RDFS.getURI())) {
                prefix = "rdfs:";
            }
            return prefix + uri.substring(split + 1);
        }
        return n.toString();
    }

    private static Node normalize(Node node) {
        if (node == null || node == Node.ANY) {
            return Node_RuleVariable.WILD;
        }
        return node;
    }

    private static Node toMatch(Node node) {
        return node.isVariable() ? null : node;
    }

    public boolean equals(Object o) {
        return o instanceof TriplePattern && this.nodeEqual(this.subject, ((TriplePattern)o).subject) && this.nodeEqual(this.predicate, ((TriplePattern)o).predicate) && this.nodeEqual(this.object, ((TriplePattern)o).object);
    }

    private boolean nodeEqual(Node n1, Node n2) {
        if (n1 instanceof Node_RuleVariable && n2 instanceof Node_RuleVariable) {
            return true;
        }
        return n1.equals(n2);
    }

    public int hashCode() {
        int hash = 0;
        if (!(this.subject instanceof Node_RuleVariable)) {
            hash ^= this.subject.hashCode() >> 1;
        }
        if (!(this.predicate instanceof Node_RuleVariable)) {
            hash ^= this.predicate.hashCode();
        }
        if (!(this.object instanceof Node_RuleVariable)) {
            hash ^= this.object.hashCode() << 1;
        }
        return hash;
    }

    @Override
    public boolean sameAs(Object o) {
        if (!(o instanceof TriplePattern)) {
            return false;
        }
        TriplePattern other = (TriplePattern)o;
        return Node_RuleVariable.sameNodeAs(this.subject, other.subject) && Node_RuleVariable.sameNodeAs(this.predicate, other.predicate) && Node_RuleVariable.sameNodeAs(this.object, other.object);
    }
}

