/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class AggSum
extends AggregatorBase {
    private static final NodeValue noValuesToSum = NodeValue.nvZERO;

    public AggSum(Expr expr) {
        super("SUM", false, expr);
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggSum(exprs.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccSum(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToSum);
    }

    @Override
    public int hashCode() {
        return 0x17C ^ this.getExpr().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggSum)) {
            return false;
        }
        AggSum agg = (AggSum)other;
        return agg.getExpr().equals(this.getExpr());
    }

    private static class AccSum
    extends AccumulatorExpr {
        private NodeValue total = null;

        public AccSum(Expr expr) {
            super(expr);
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                this.total = this.total == null ? nv : XSDFuncOp.numAdd(nv, this.total);
            } else {
                throw new ExprEvalException("Not a number: " + nv);
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return this.total;
        }
    }
}

