/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit;

import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.BagInfoTxtReader;
import gov.loc.repository.bagit.BagInfoTxtWriter;
import gov.loc.repository.bagit.BagItTxt;
import gov.loc.repository.bagit.BagItTxtReader;
import gov.loc.repository.bagit.BagItTxtWriter;
import gov.loc.repository.bagit.BagVisitor;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.FetchTxtReader;
import gov.loc.repository.bagit.FetchTxtWriter;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestReader;
import gov.loc.repository.bagit.ManifestWriter;
import gov.loc.repository.bagit.transformer.Completer;
import gov.loc.repository.bagit.transformer.HolePuncher;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import gov.loc.repository.bagit.verify.Verifier;
import gov.loc.repository.bagit.writer.Writer;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface Bag
extends Closeable {
    public BagFactory.Version getVersion();

    public File getFile();

    public void setFile(File var1);

    public List<Manifest> getPayloadManifests();

    public Manifest getPayloadManifest(Manifest.Algorithm var1);

    public List<Manifest> getTagManifests();

    public Manifest getTagManifest(Manifest.Algorithm var1);

    public Collection<BagFile> getTags();

    public Collection<BagFile> getPayload();

    public void removeBagFile(String var1);

    public void removeTagDirectory(String var1);

    public void removePayloadDirectory(String var1);

    public BagFile getBagFile(String var1);

    public void putBagFile(BagFile var1);

    public void putBagFiles(Collection<BagFile> var1);

    public void addFileToPayload(File var1);

    public void addFilesToPayload(List<File> var1);

    public void addFileAsTag(File var1);

    public void addFilesAsTag(List<File> var1);

    public Map<Manifest.Algorithm, String> getChecksums(String var1);

    public BagItTxt getBagItTxt();

    public BagInfoTxt getBagInfoTxt();

    public FetchTxt getFetchTxt();

    public Format getFormat();

    public SimpleResult verifyValid();

    public SimpleResult verifyValid(FailModeSupporting.FailMode var1);

    public SimpleResult verifyComplete();

    public SimpleResult verifyComplete(FailModeSupporting.FailMode var1);

    public SimpleResult verify(Verifier var1);

    public SimpleResult verifyPayloadManifests();

    public SimpleResult verifyPayloadManifests(FailModeSupporting.FailMode var1);

    public SimpleResult verifyTagManifests();

    public SimpleResult verifyTagManifests(FailModeSupporting.FailMode var1);

    public void loadFromManifests();

    public void loadFromFiles();

    public void loadFromFiles(List<String> var1);

    public void accept(BagVisitor var1);

    public Bag write(Writer var1, File var2);

    public Bag makeHoley(String var1, boolean var2, boolean var3, boolean var4);

    public Bag makeHoley(HolePuncher var1, String var2, boolean var3, boolean var4, boolean var5);

    public Bag makeComplete();

    public Bag makeComplete(Completer var1);

    public BagConstants getBagConstants();

    public BagPartFactory getBagPartFactory();

    public static interface BagPartFactory {
        public ManifestReader createManifestReader(InputStream var1, String var2);

        public ManifestReader createManifestReader(InputStream var1, String var2, boolean var3);

        public ManifestWriter createManifestWriter(OutputStream var1);

        public ManifestWriter createManifestWriter(OutputStream var1, String var2);

        public Manifest createManifest(String var1);

        public Manifest createManifest(String var1, BagFile var2);

        public BagItTxtReader createBagItTxtReader(String var1, InputStream var2);

        public BagItTxtWriter createBagItTxtWriter(OutputStream var1, String var2, int var3, int var4);

        public BagItTxtWriter createBagItTxtWriter(OutputStream var1, String var2);

        public BagItTxt createBagItTxt(BagFile var1);

        public BagItTxt createBagItTxt();

        public BagInfoTxtReader createBagInfoTxtReader(String var1, InputStream var2);

        public BagInfoTxtWriter createBagInfoTxtWriter(OutputStream var1, String var2, int var3, int var4);

        public BagInfoTxtWriter createBagInfoTxtWriter(OutputStream var1, String var2);

        public BagInfoTxt createBagInfoTxt(BagFile var1);

        public BagInfoTxt createBagInfoTxt();

        public FetchTxtReader createFetchTxtReader(InputStream var1, String var2);

        public FetchTxtWriter createFetchTxtWriter(OutputStream var1);

        public FetchTxt createFetchTxt();

        public FetchTxt createFetchTxt(BagFile var1);

        public BagFactory.Version getVersion();
    }

    public static interface BagConstants {
        public String getPayloadManifestPrefix();

        public String getTagManifestPrefix();

        public String getPayloadManifestSuffix();

        public String getTagManifestSuffix();

        public String getBagEncoding();

        public String getBagItTxt();

        public String getDataDirectory();

        public String getBagInfoTxt();

        public String getFetchTxt();

        public BagFactory.Version getVersion();
    }

    public static enum Format {
        ZIP("zip", true, ".zip"),
        FILESYSTEM("file", false, "");

        public String scheme;
        public boolean isSerialized;
        public String extension;

        private Format(String scheme, boolean isSerialized, String extension) {
            this.scheme = scheme;
            this.isSerialized = isSerialized;
            this.extension = extension;
        }
    }
}

