/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.SQLException;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.ConditionInterface;
import org.ecoinformatics.datamanager.database.Query;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.Entity;

public class SubQueryClause
implements ConditionInterface {
    private static final String IN = "IN";
    private static final String NOT_IN = "NOT IN";
    private static final String LEFT_PARENSIS = "(";
    private static final String RIGHT_PARENSIS = ")";
    private String operator = null;
    private Entity entity = null;
    private Attribute attribute = null;
    private Query query = null;

    public SubQueryClause(Entity entity, Attribute attribute, String operator, Query query) {
        this.entity = entity;
        this.attribute = attribute;
        this.operator = operator;
        this.query = query;
    }

    @Override
    public String toSQLString() throws UnWellFormedQueryException {
        if (this.attribute == null) {
            throw new UnWellFormedQueryException("Attribute part in sub query couldn't be null");
        }
        if (this.operator == null || !this.operator.equalsIgnoreCase(IN) && !this.operator.equalsIgnoreCase(NOT_IN)) {
            throw new UnWellFormedQueryException("Operator in sub query should be IN or NOT IN");
        }
        if (this.query == null) {
            throw new UnWellFormedQueryException("Query part shouldn't be null in sub query");
        }
        StringBuffer sql = new StringBuffer();
        if (this.entity != null) {
            String entityName = null;
            try {
                entityName = DataManager.getDBTableName(this.entity);
            }
            catch (SQLException sqle) {
                System.err.println("entity name is null " + sqle.getMessage());
            }
            if (entityName != null && !entityName.trim().equals("")) {
                sql.append(entityName);
                sql.append(".");
            }
        }
        String attributeName = null;
        try {
            attributeName = DataManager.getDBFieldName(this.entity, this.attribute);
        }
        catch (SQLException sqle) {
            System.err.println("attribute name is null " + sqle.getMessage());
        }
        if (attributeName == null || attributeName.trim().equals("")) {
            throw new UnWellFormedQueryException("Attribute name in sub query couldn't be null");
        }
        sql.append(attributeName);
        sql.append(" ");
        sql.append(this.operator);
        sql.append(" ");
        sql.append(LEFT_PARENSIS);
        sql.append(this.removeSemicolon(this.query.toSQLString()));
        sql.append(RIGHT_PARENSIS);
        return sql.toString();
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    private String removeSemicolon(String query) {
        String queryWithoutSemiconlon = null;
        if (query != null) {
            queryWithoutSemiconlon = query.replaceAll(";", " ");
        }
        return queryWithoutSemiconlon;
    }
}

