/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.RuntimeInterruptedException;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.LockProxy;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.monitor.LocalLockStatsImpl;
import com.hazelcast.impl.monitor.LockOperationsCounter;
import com.hazelcast.monitor.LocalLockStats;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.SerializationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class LockProxyImpl
extends SerializationHelper
implements HazelcastInstanceAwareInstance,
LockProxy,
DataSerializable {
    private Object key = null;
    private transient LockProxy base = null;
    private transient FactoryImpl factory = null;

    public LockProxyImpl() {
    }

    LockProxyImpl(HazelcastInstance hazelcastInstance, Object key) {
        this.key = key;
        this.setHazelcastInstance(hazelcastInstance);
        this.base = new LockProxyBase();
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (LockProxy)this.factory.getLock(this.key);
        }
    }

    public String toString() {
        return "ILock [" + this.key + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockProxyImpl lockProxy = (LockProxyImpl)o;
        return !(this.key == null ? lockProxy.key != null : !this.key.equals(lockProxy.key));
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public void writeData(DataOutput out) throws IOException {
        LockProxyImpl.writeObject(out, this.key);
    }

    public void readData(DataInput in) throws IOException {
        this.key = LockProxyImpl.readObject(in);
        this.setHazelcastInstance(ThreadContext.get().getCurrentFactory());
    }

    public void lock() {
        this.ensure();
        this.base.lock();
    }

    public boolean isLocked() {
        this.ensure();
        return this.base.isLocked();
    }

    public void lockInterruptibly() throws InterruptedException {
        this.ensure();
        this.base.lockInterruptibly();
    }

    public boolean tryLock() {
        this.ensure();
        return this.base.tryLock();
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        this.ensure();
        return this.base.tryLock(time, unit);
    }

    public void unlock() {
        this.ensure();
        this.base.unlock();
    }

    public void forceUnlock() {
        this.ensure();
        this.base.forceUnlock();
    }

    public Condition newCondition() {
        this.ensure();
        return this.base.newCondition();
    }

    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return Instance.InstanceType.LOCK;
    }

    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    public Object getLockObject() {
        return this.key;
    }

    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public LocalLockStats getLocalLockStats() {
        this.ensure();
        return this.base.getLocalLockStats();
    }

    public LockOperationsCounter getLockOperationCounter() {
        this.ensure();
        return this.base.getLockOperationCounter();
    }

    private class LockProxyBase
    implements LockProxy {
        private LockOperationsCounter lockOperationsCounter = new LockOperationsCounter();

        private LockProxyBase() {
        }

        public void lock() {
            ((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.lock(LockProxyImpl.this.key);
            this.lockOperationsCounter.incrementLocks();
        }

        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException("lockInterruptibly() is not implemented!");
        }

        public boolean isLocked() {
            return ((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.isLocked(LockProxyImpl.this.key);
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException("newCondition() is not implemented!");
        }

        public boolean tryLock() {
            if (((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.tryLock(LockProxyImpl.this.key)) {
                this.lockOperationsCounter.incrementLocks();
                return true;
            }
            this.lockOperationsCounter.incrementFailedLocks();
            return false;
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            try {
                if (((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.tryLock(LockProxyImpl.this.key, time, unit)) {
                    this.lockOperationsCounter.incrementLocks();
                    return true;
                }
            }
            catch (RuntimeInterruptedException e) {
                this.lockOperationsCounter.incrementFailedLocks();
                throw new InterruptedException();
            }
            this.lockOperationsCounter.incrementFailedLocks();
            return false;
        }

        public void unlock() {
            ((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.unlock(LockProxyImpl.this.key);
            this.lockOperationsCounter.incrementUnlocks();
        }

        public void forceUnlock() {
            ((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.forceUnlock(LockProxyImpl.this.key);
            this.lockOperationsCounter.incrementUnlocks();
        }

        public void destroy() {
            LockProxyImpl.this.factory.destroyInstanceClusterWide("lock", LockProxyImpl.this.key);
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.LOCK;
        }

        public Object getLockObject() {
            return LockProxyImpl.this.key;
        }

        public Object getId() {
            return new FactoryImpl.ProxyKey("lock", LockProxyImpl.this.key);
        }

        public LocalLockStats getLocalLockStats() {
            LocalLockStatsImpl localLockStats = new LocalLockStatsImpl();
            localLockStats.setOperationStats(this.lockOperationsCounter.getPublishedStats());
            return localLockStats;
        }

        public LockOperationsCounter getLockOperationCounter() {
            return this.lockOperationsCounter;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

