/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.reader;

import java.io.IOException;
import java.io.InputStream;

public class SizeLimitInputStream
extends InputStream {
    private boolean closed = false;
    protected long currentPosition = 0L;
    protected InputStream in;
    protected long markPosition = 0L;
    protected final long maxSize;

    public SizeLimitInputStream(InputStream in, long maxSize) {
        this.in = in;
        this.maxSize = maxSize;
    }

    public int available() throws IOException {
        return Math.min(this.in.available(), (int)this.getBytesLeft());
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    public long getBytesLeft() {
        return this.maxSize - this.currentPosition;
    }

    public long getBytesRead() {
        return this.currentPosition;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markPosition = this.currentPosition;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        int result;
        if (this.currentPosition >= this.maxSize) {
            result = -1;
        } else {
            result = this.in.read();
            if (result >= 0) {
                ++this.currentPosition;
            }
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesReaded;
        if (this.currentPosition >= this.maxSize) {
            bytesReaded = -1;
        } else {
            int n = (int)Math.min(this.getBytesLeft(), (long)len);
            bytesReaded = this.in.read(b, off, n);
            if (bytesReaded > 0) {
                this.currentPosition += (long)bytesReaded;
            }
        }
        return bytesReaded;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.currentPosition = this.markPosition;
        this.markPosition = 0L;
    }

    public long skip(long n) throws IOException {
        long result;
        if (this.currentPosition >= this.maxSize) {
            result = -1L;
        } else {
            result = this.in.skip(Math.min(n, this.getBytesLeft()));
            if (result > 0L) {
                this.currentPosition += result;
            }
        }
        return result;
    }
}

