/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.Cacheable;
import edu.uiuc.ncsa.security.core.cache.CachedMapFacade;
import edu.uiuc.ncsa.security.core.exceptions.DestroyedException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TransactionCache<V extends BasicTransaction>
extends CachedMapFacade<V>
implements TransactionStore<V> {
    TransactionIndices transactionIndices;
    AbstractEnvironment environment;
    boolean destroyed = true;
    final int TEMP_CRED = 0;
    final int ACCESS_TOKEN = 1;
    final int VERIFIER = 2;
    final int IDENTIFIER = 3;

    public TransactionStore getBackingStore() {
        return (TransactionStore)this.getTheStore();
    }

    public TransactionCache(TransactionStore backingStore) {
        super((Store)backingStore);
        this.init();
    }

    public TransactionIndices getTransactionIndices() {
        if (this.transactionIndices == null) {
            this.transactionIndices = new TransactionIndices();
        }
        return this.transactionIndices;
    }

    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    public TransactionCache() {
        this.init();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public boolean destroy() {
        this.setDestroyed(true);
        this.getTransactionIndices().clear();
        this.getCache().clear();
        if (this.hasStore()) {
            this.getTheStore().clear();
        }
        return false;
    }

    public boolean init() {
        this.setDestroyed(false);
        this.getTransactionIndices().clear();
        this.getCache().clear();
        return true;
    }

    public void put(V t) {
        this.checkDestroyed();
        this.getTransactionIndices().add(t);
        this.getCache().add(t);
    }

    protected void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new DestroyedException();
        }
    }

    public void update(BasicTransaction t) {
        if (t == null) {
            throw new GeneralException("Error: null transaction cannot be updated");
        }
        this.checkDestroyed();
        if (!this.containsKey(t.getIdentifier())) {
            throw new GeneralException("Error: non-existent transaction \"" + t.getIdentifierString() + "\" cannot be updated. Save it first.");
        }
        this.getTransactionIndices().updateIndices(t);
        this.getTransactionIndices().add(t);
        this.getCache().add((Cacheable)t);
        if (this.hasStore()) {
            this.getBackingStore().update((Identifiable)t);
        }
    }

    protected V getByKey(Object key, int action) {
        this.checkDestroyed();
        BasicTransaction t = null;
        switch (action) {
            case 0: {
                t = (BasicTransaction)((Object)this.getTransactionIndices().get((AuthorizationGrant)key));
                break;
            }
            case 1: {
                t = (BasicTransaction)((Object)this.getTransactionIndices().get((AccessToken)key));
                break;
            }
            case 2: {
                t = (BasicTransaction)((Object)this.getTransactionIndices().get((Verifier)key));
                break;
            }
            case 3: {
                t = (BasicTransaction)((Object)this.getTransactionIndices().get((Identifier)key));
                break;
            }
            default: {
                throw new IllegalStateException("Error: unrecognized action for getting a transaction");
            }
        }
        if (t != null) {
            return (V)((Object)t);
        }
        if (this.hasStore()) {
            switch (action) {
                case 0: {
                    t = (BasicTransaction)((Object)this.getBackingStore().get((AuthorizationGrant)key));
                    break;
                }
                case 1: {
                    t = (BasicTransaction)((Object)this.getBackingStore().get((AccessToken)key));
                    break;
                }
                case 2: {
                    t = (BasicTransaction)((Object)this.getBackingStore().get((Verifier)key));
                    break;
                }
                case 3: {
                    t = (BasicTransaction)((Object)this.getBackingStore().get(key));
                }
            }
            if (t != null) {
                this.getTransactionIndices().add(t);
            }
        }
        return (V)((Object)t);
    }

    @Override
    public V get(AuthorizationGrant tempCred) {
        return this.getByKey(tempCred, 0);
    }

    @Override
    public V get(AccessToken accessToken) {
        return this.getByKey(accessToken, 1);
    }

    @Override
    public V get(Verifier verifier) {
        return this.getByKey(verifier, 2);
    }

    public int size() {
        this.checkDestroyed();
        return super.size();
    }

    public boolean isEmpty() {
        this.checkDestroyed();
        return super.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.checkDestroyed();
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.checkDestroyed();
        return super.containsValue(value);
    }

    public V get(Object key) {
        return (V)((Object)((BasicTransaction)super.get(key)));
    }

    public BasicTransaction remove(URI identifier) {
        this.checkDestroyed();
        this.getTransactionIndices().remove(identifier.toString());
        return (BasicTransaction)super.remove((Object)identifier.toString());
    }

    public V create() {
        this.checkDestroyed();
        if (this.hasStore()) {
            return (V)((Object)((BasicTransaction)this.getBackingStore().create()));
        }
        return (V)((Object)new BasicTransaction((Identifier)null));
    }

    public V put(Identifier key, V value) {
        this.checkDestroyed();
        this.getTransactionIndices().add(value);
        return (V)((Object)((BasicTransaction)super.put(key, value)));
    }

    public V remove(Object key) {
        this.checkDestroyed();
        Object t = this.getTransactionIndices().remove(key);
        return (V)((Object)((BasicTransaction)super.remove(key)));
    }

    public void putAll(Map m) {
        this.checkDestroyed();
        super.putAll(m);
    }

    public void clear() {
        this.checkDestroyed();
        this.getTransactionIndices().clear();
        super.clear();
    }

    public Set<Identifier> keySet() {
        this.checkDestroyed();
        return super.keySet();
    }

    public Collection<V> values() {
        this.checkDestroyed();
        return super.values();
    }

    public Set<Map.Entry<Identifier, V>> entrySet() {
        this.checkDestroyed();
        return super.entrySet();
    }

    public void save(V t) {
        this.checkDestroyed();
        this.put(t);
        if (this.hasStore()) {
            this.getBackingStore().save((Identifiable)t);
        }
    }

    public BasicTransaction remove(BasicTransaction t) {
        return this.remove(t.getIdentifierString());
    }

    public void register(V transaction) {
        this.put(transaction);
    }

    public String toString() {
        return "TransactionCache[" + this.getCache().size() + " elements, " + (this.hasStore() ? "has a" : "no") + " store]";
    }

    public static class TransactionIndices<V extends BasicTransaction> {
        HashMap<Identifier, V> createdTransactions;
        HashMap<Identifier, V> transactions;
        HashMap<String, Identifier> AuthorizationGrantIndex;
        HashMap<String, Identifier> verifierIndex;
        HashMap<String, Identifier> accessTokenIndex;

        public HashMap<Identifier, V> getCreatedTransactions() {
            if (this.createdTransactions == null) {
                this.createdTransactions = new HashMap();
            }
            return this.createdTransactions;
        }

        public void add(V t) {
            this.getTransactions().put(t.getIdentifier(), t);
            this.getCreatedTransactions().remove(t.getIdentifier());
            this.updateIndices((BasicTransaction)((Object)t));
        }

        public void remove(V t) {
            this.getTransactions().remove(t.getIdentifierString());
            this.removeFromIndices((BasicTransaction)((Object)t));
        }

        protected Map<Identifier, V> getTransactions() {
            if (this.transactions == null) {
                this.transactions = new HashMap();
            }
            return this.transactions;
        }

        public V get(Identifier identifier) {
            return (V)((Object)((BasicTransaction)((Object)this.getTransactions().get(identifier))));
        }

        public V get(AuthorizationGrant authorizationGrant) {
            if (!this.getAuthorizationGrantIndex().containsKey(authorizationGrant.getToken())) {
                return null;
            }
            return this.get(this.getAuthorizationGrantIndex().get(authorizationGrant.getToken()));
        }

        public V get(AccessToken accessToken) {
            if (!this.getAccessTokenIndex().containsKey(accessToken.getToken())) {
                return null;
            }
            return this.get(this.getAccessTokenIndex().get(accessToken.getToken()));
        }

        public V get(Verifier verifier) {
            if (!this.getVerifierIndex().containsKey(verifier.getToken())) {
                return null;
            }
            return this.get(this.getVerifierIndex().get(verifier.getToken()));
        }

        public void clear() {
            this.transactions = null;
            this.verifierIndex = null;
            this.accessTokenIndex = null;
            this.AuthorizationGrantIndex = null;
            this.createdTransactions = null;
        }

        public int size() {
            return this.getTransactions().size();
        }

        public boolean isEmpty() {
            return this.getTransactions().isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.getTransactions().containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.getTransactions().containsValue(value);
        }

        public V put(Identifier key, V value) {
            V oldT = this.get(key);
            this.add(value);
            return oldT;
        }

        public V remove(Object key) {
            BasicTransaction oldT = (BasicTransaction)((Object)this.getTransactions().remove(key));
            if (oldT != null) {
                this.removeFromIndices(oldT);
            }
            return (V)((Object)oldT);
        }

        public void putAll(Map<? extends String, ? extends BasicTransaction> m) {
            for (BasicTransaction basicTransaction : m.values()) {
                this.add(basicTransaction);
            }
        }

        public Set<Identifier> keySet() {
            return this.getTransactions().keySet();
        }

        public Collection<V> values() {
            return this.getTransactions().values();
        }

        public Set<Map.Entry<Identifier, V>> entrySet() {
            return this.getTransactions().entrySet();
        }

        protected HashMap<String, Identifier> getAuthorizationGrantIndex() {
            if (this.AuthorizationGrantIndex == null) {
                this.AuthorizationGrantIndex = new HashMap();
            }
            return this.AuthorizationGrantIndex;
        }

        protected HashMap<String, Identifier> getVerifierIndex() {
            if (this.verifierIndex == null) {
                this.verifierIndex = new HashMap();
            }
            return this.verifierIndex;
        }

        protected HashMap<String, Identifier> getAccessTokenIndex() {
            if (this.accessTokenIndex == null) {
                this.accessTokenIndex = new HashMap();
            }
            return this.accessTokenIndex;
        }

        protected void updateIndices(BasicTransaction t) {
            if (t.hasAccessToken()) {
                this.getAccessTokenIndex().put(t.getAccessToken().getToken(), t.getIdentifier());
            }
            if (t.hasAuthorizationGrant()) {
                this.getAuthorizationGrantIndex().put(t.getAuthorizationGrant().getToken(), t.getIdentifier());
            }
            if (t.hasVerifier()) {
                this.getVerifierIndex().put(t.getVerifier().getToken(), t.getIdentifier());
            }
        }

        protected void removeFromIndices(BasicTransaction t) {
            if (t.hasAccessToken()) {
                this.getAccessTokenIndex().remove(t.getAccessToken().getToken());
            }
            if (t.hasAuthorizationGrant()) {
                this.getAuthorizationGrantIndex().remove(t.getAuthorizationGrant().getToken());
            }
            if (t.hasVerifier()) {
                this.getVerifierIndex().remove(t.getVerifier().getToken());
            }
        }
    }
}

