/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.Request;
import com.hazelcast.util.Clock;
import java.util.concurrent.atomic.AtomicLong;

public abstract class ScheduledAction {
    private static final AtomicLong idGen = new AtomicLong();
    protected long timeToExpire;
    protected long timeout;
    protected boolean valid = true;
    protected final Request request;
    protected final long id;

    public ScheduledAction(Request request) {
        this.request = request;
        this.setTimeout(request.timeout);
        this.id = idGen.incrementAndGet();
    }

    public abstract boolean consume();

    public boolean expired() {
        return !this.valid || this.timeout != -1L && Clock.currentTimeMillis() >= this.getExpireTime();
    }

    public long getExpireTime() {
        return this.timeToExpire;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledAction that = (ScheduledAction)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean neverExpires() {
        return this.timeout == -1L;
    }

    public void onExpire() {
    }

    public void onMigrate() {
    }

    public void setTimeout(long newTimeout) {
        if (newTimeout > -1L) {
            this.timeout = newTimeout;
            this.timeToExpire = Clock.currentTimeMillis() + newTimeout;
            if (this.timeToExpire < 0L) {
                this.timeout = -1L;
                this.timeToExpire = Long.MAX_VALUE;
            }
        } else {
            this.timeout = -1L;
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]{ neverExpires=" + this.neverExpires() + ", timeout= " + this.timeout + "}";
    }

    public Request getRequest() {
        return this.request;
    }
}

