/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.DatabaseAdapter;
import org.ecoinformatics.datamanager.database.TableMonitor;
import org.ecoinformatics.datamanager.database.TextDataReader;
import org.ecoinformatics.datamanager.download.DataSourceNotFoundException;
import org.ecoinformatics.datamanager.download.DataStorageInterface;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.Entity;

public class SimpleDatabaseLoader
implements DataStorageInterface,
Runnable {
    private static TableMonitor tableMonitor = null;
    public static Log log = LogFactory.getLog(SimpleDatabaseLoader.class);
    private Entity entity = null;
    private TextDataReader dataReader = null;
    private DatabaseAdapter databaseAdapter = null;
    private boolean completed = false;
    private boolean success = false;
    private Exception exception = null;

    public SimpleDatabaseLoader(String databaseAdapterName, Entity entity, TextDataReader dataReader) {
        this.entity = entity;
        this.dataReader = dataReader;
        this.databaseAdapter = DataManager.getDatabaseAdapterObject(databaseAdapterName);
        try {
            tableMonitor = new TableMonitor(this.databaseAdapter);
        }
        catch (SQLException e) {
            log.error((Object)("problem setting table monitor: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.entity == null) {
            this.success = false;
            this.completed = true;
            return;
        }
        if (this.doesDataExist(this.entity.getEntityIdentifier())) {
            return;
        }
        AttributeList attributeList = this.entity.getAttributeList();
        String tableName = this.entity.getDBTableName();
        String insertSQL = "";
        Vector<Object> rowVector = new Vector();
        Connection connection = null;
        try {
            rowVector = this.dataReader.getOneRowDataVector();
            connection = DataManager.getConnection();
            if (connection == null) {
                this.success = false;
                this.exception = new Exception("The connection to db is null");
                this.completed = true;
                return;
            }
            connection.setAutoCommit(false);
            while (!rowVector.isEmpty()) {
                insertSQL = this.databaseAdapter.generateInsertSQL(attributeList, tableName, rowVector);
                if (insertSQL != null) {
                    PreparedStatement statement = connection.prepareStatement(insertSQL);
                    statement.execute();
                }
                rowVector = this.dataReader.getOneRowDataVector();
            }
            connection.commit();
            this.success = true;
        }
        catch (Exception e) {
            log.error((Object)("problem while loading data into table.  Error message: " + e.getMessage()));
            e.printStackTrace();
            log.error((Object)("SQL string to insert row:\n" + insertSQL));
            this.success = false;
            this.exception = e;
            try {
                connection.rollback();
            }
            catch (Exception ee) {
                System.err.println(ee.getMessage());
            }
        }
        finally {
            try {
                connection.setAutoCommit(true);
            }
            catch (Exception ee) {
                log.error((Object)ee.getMessage());
            }
            DataManager.returnConnection(connection);
        }
    }

    @Override
    public boolean doesDataExist(String identifier) {
        boolean doesExist = false;
        try {
            String tableName = tableMonitor.identifierToTableName(identifier);
            doesExist = tableMonitor.isTableInDB(tableName);
            if (doesExist) {
                int rowCount = tableMonitor.countRows(tableName);
                doesExist = rowCount > 0;
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return doesExist;
    }

    @Override
    public boolean isCompleted(String identifier) {
        return this.completed || this.doesDataExist(identifier);
    }

    @Override
    public boolean isSuccess(String identifier) {
        return this.success || this.doesDataExist(identifier);
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void finishSerialize(String indentifier, String errorCode) {
        log.warn((Object)"unimplemented method called");
    }

    @Override
    public InputStream load(String identifier) throws DataSourceNotFoundException {
        log.warn((Object)"unimplemented method called");
        return null;
    }

    @Override
    public OutputStream startSerialize(String identifier) {
        log.warn((Object)"unimplemented method called");
        return null;
    }
}

