/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.TransactionNotFoundException;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransactionTable;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.Token;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Provider;

public abstract class SQLBaseTransactionStore<V extends BasicTransaction>
extends SQLStore<V>
implements TransactionStore<V> {
    protected TokenForge tokenForge;

    protected SQLBaseTransactionStore(TokenForge tokenForge, ConnectionPool connectionPool, Table table, Provider<V> idp, MapConverter converter) {
        super(connectionPool, table, idp, converter);
        this.tokenForge = tokenForge;
    }

    public BasicTransactionTable getTransactionTable() {
        return (BasicTransactionTable)this.getTable();
    }

    protected V getTransaction(String identifier, String statement) {
        if (identifier == null) {
            throw new IllegalStateException("Error: a null identifier was supplied");
        }
        Connection c = this.getConnection();
        BasicTransaction t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(statement);
            stmt.setString(1, identifier);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                throw new TransactionNotFoundException("No transaction found for identifier \"" + identifier + "\"");
            }
            ColumnMap map = this.rsToMap(rs);
            rs.close();
            stmt.close();
            t = (BasicTransaction)this.create();
            this.populate(map, (Identifiable)t);
        }
        catch (SQLException e) {
            throw new GeneralException("Error getting transaction with identifier \"" + identifier + "\"", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
        return (V)((Object)t);
    }

    @Override
    public V get(AuthorizationGrant tempCred) {
        try {
            V t = this.getTransaction(tempCred.getToken(), this.getTransactionTable().getByTempCredStatement());
            return t;
        }
        catch (TransactionNotFoundException x) {
            return null;
        }
    }

    @Override
    public V get(AccessToken accessToken) {
        try {
            V t = this.getTransaction(accessToken.getToken(), this.getTransactionTable().getByAccessTokenStatement());
            return t;
        }
        catch (TransactionNotFoundException x) {
            return null;
        }
    }

    @Override
    public V get(Verifier verifier) {
        try {
            V t = this.getTransaction(verifier.getToken(), this.getTransactionTable().getByVerifierStatement());
            return t;
        }
        catch (TransactionNotFoundException x) {
            return null;
        }
    }

    protected String getToken(Token at) throws SQLException {
        return at == null ? null : at.getToken();
    }
}

