/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedFloat
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected float value_;

    public SynchronizedFloat(float initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedFloat(float initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public float add(float amount) {
        Object object = this.lock_;
        synchronized (object) {
            float f = this.value_ += amount;
            Object var4_4 = null;
            return f;
        }
    }

    public boolean commit(float assumedValue, float newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            boolean bl2 = success;
            Object var5_6 = null;
            return bl2;
        }
    }

    public int compareTo(float other) {
        float val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedFloat other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedFloat)other);
    }

    public float divide(float factor) {
        Object object = this.lock_;
        synchronized (object) {
            float f = this.value_ /= factor;
            Object var4_4 = null;
            return f;
        }
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedFloat) {
            return this.get() == ((SynchronizedFloat)other).get();
        }
        return false;
    }

    public final float get() {
        Object object = this.lock_;
        synchronized (object) {
            float f = this.value_;
            Object var3_3 = null;
            return f;
        }
    }

    public int hashCode() {
        return Float.floatToIntBits(this.get());
    }

    public synchronized float multiply(float factor) {
        Object object = this.lock_;
        synchronized (object) {
            float f = this.value_ *= factor;
            Object var4_4 = null;
            return f;
        }
    }

    public float set(float newValue) {
        Object object = this.lock_;
        synchronized (object) {
            float old = this.value_;
            this.value_ = newValue;
            float f = old;
            Object var4_5 = null;
            return f;
        }
    }

    public float subtract(float amount) {
        Object object = this.lock_;
        synchronized (object) {
            float f = this.value_ -= amount;
            Object var4_4 = null;
            return f;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float swap(SynchronizedFloat other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedFloat fst = this;
        SynchronizedFloat snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            Object object2 = snd.lock_;
            synchronized (object2) {
                fst.set(snd.set(fst.get()));
                return this.get();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

