/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.setup;

import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.setup.StoreParamsBuilder;
import com.hp.hpl.jena.tdb.setup.StoreParamsCodec;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import com.hp.hpl.jena.tdb.sys.DatasetControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Build {
    private static boolean VERBOSE = true;
    private static Logger log = LoggerFactory.getLogger(Build.class);
    private static StoreParams params = StoreParams.getDftStoreParams();

    public static TupleIndex openTupleIndex(Location loc, String indexName, String primary, String indexOrder) {
        return Build.openTupleIndex(loc, indexName, primary, indexOrder, params);
    }

    public static TupleIndex openTupleIndex(Location location, String indexName, String primary, String indexOrder, StoreParams params) {
        return DatasetBuilderStd.stdBuilder().makeTupleIndex(location, indexName, primary, indexOrder, params);
    }

    public static TupleIndex openTupleIndex(Location location, String indexName, String primary, String indexOrder, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        StoreParamsBuilder spb = StoreParams.builder();
        spb.blockReadCacheSize(readCacheSize);
        spb.blockWriteCacheSize(writeCacheSize);
        return Build.openTupleIndex(location, indexName, primary, indexOrder, spb.build());
    }

    public static DatasetPrefixesTDB makePrefixes(Location location, DatasetControl policy) {
        return DatasetBuilderStd.stdBuilder().makePrefixTable(location, policy, params);
    }

    public static NodeTable makeNodeTable(Location location) {
        return Build.makeNodeTable(location, params);
    }

    public static NodeTable makeNodeTable(Location location, StoreParams params) {
        DatasetBuilderStd dbBuild = DatasetBuilderStd.stdBuilder();
        return dbBuild.makeNodeTable(location, params);
    }

    public static NodeTable makeNodeTable(Location location, String indexNode2Id, int node2NodeIdCacheSize, String indexId2Node, int nodeId2NodeCacheSize, int sizeNodeMissCacheSize) {
        StoreParamsBuilder spb = StoreParams.builder();
        spb.indexNode2Id(indexNode2Id).node2NodeIdCacheSize(node2NodeIdCacheSize);
        spb.indexId2Node(indexId2Node).nodeId2NodeCacheSize(nodeId2NodeCacheSize);
        DatasetBuilderStd dbBuild = DatasetBuilderStd.stdBuilder();
        return Build.makeNodeTable(location, spb.build());
    }

    static StoreParams decideStoreParams(Location location, boolean isNew, StoreParams pApp, StoreParams pLoc, StoreParams pDft) {
        StoreParams p = null;
        if (pLoc != null) {
            p = pLoc;
            if (pApp != null) {
                p = StoreParamsBuilder.modify(pLoc, pApp);
            }
            return p;
        }
        if (pApp != null) {
            if (isNew) {
                if (!location.isMem()) {
                    String filename = location.getPath("tdb.cfg");
                    StoreParamsCodec.write(filename, pApp);
                }
                return pApp;
            }
            return StoreParamsBuilder.modify(pDft, pApp);
        }
        return pDft;
    }
}

