/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrSync;
import java.util.Iterator;
import org.apache.jena.atlas.lib.ActionKeyValue;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrCache
extends BlockMgrSync {
    private static Logger log = LoggerFactory.getLogger(BlockMgrCache.class);
    private final Cache<Long, Block> readCache;
    private final Cache<Long, Block> writeCache;
    public static boolean globalLogging = false;
    private boolean logging = false;
    long cacheReadHits = 0L;
    long cacheMisses = 0L;
    long cacheWriteHits = 0L;

    static BlockMgr create(int readSlots, int writeSlots, BlockMgr blockMgr) {
        if (readSlots < 0 && writeSlots < 0) {
            return blockMgr;
        }
        return new BlockMgrCache(readSlots, writeSlots, blockMgr);
    }

    private BlockMgrCache(int readSlots, int writeSlots, BlockMgr blockMgr) {
        super(blockMgr);
        this.readCache = readSlots < -1 ? CacheFactory.createNullCache() : CacheFactory.createCache((int)readSlots);
        if (writeSlots <= 0) {
            this.writeCache = null;
        } else {
            this.writeCache = CacheFactory.createCache((int)writeSlots);
            this.writeCache.setDropHandler((ActionKeyValue)new ActionKeyValue<Long, Block>(){

                public void apply(Long id, Block block) {
                    BlockMgrCache.this.log("Cache spill: write block: %d", new Object[]{id});
                    if (block == null) {
                        log.warn("Write cache: " + id + " dropping an entry that isn't there");
                        return;
                    }
                    BlockMgrCache.super.write(block);
                }
            });
        }
    }

    @Override
    public synchronized Block getRead(long id) {
        Block blk = (Block)this.readCache.get((Object)id);
        if (blk != null) {
            ++this.cacheReadHits;
            this.log("Hit(r->r) : %d", id);
            return blk;
        }
        if (this.writeCache != null) {
            blk = (Block)this.writeCache.get((Object)id);
        }
        if (blk != null) {
            ++this.cacheWriteHits;
            this.log("Hit(r->w) : %d", id);
            return blk;
        }
        ++this.cacheMisses;
        this.log("Miss/r: %d", id);
        blk = super.getRead(id);
        this.readCache.put((Object)id, (Object)blk);
        return blk;
    }

    @Override
    public synchronized Block getReadIterator(long id) {
        return this.getRead(id);
    }

    @Override
    public synchronized Block getWrite(long _id) {
        Long id = _id;
        Block blk = null;
        if (this.writeCache != null) {
            blk = (Block)this.writeCache.get((Object)id);
        }
        if (blk != null) {
            ++this.cacheWriteHits;
            this.log("Hit(w->w) : %d", id);
            return blk;
        }
        if (this.readCache.containsKey((Object)id)) {
            blk = (Block)this.readCache.get((Object)id);
            ++this.cacheReadHits;
            this.log("Hit(w->r) : %d", id);
            blk = this.promote(blk);
            return blk;
        }
        ++this.cacheMisses;
        this.log("Miss/w: %d", id);
        blk = super.getWrite(id);
        if (this.writeCache != null) {
            this.writeCache.put((Object)id, (Object)blk);
        }
        return blk;
    }

    @Override
    public synchronized Block promote(Block block) {
        Long id = block.getId();
        this.readCache.remove((Object)id);
        Block block2 = super.promote(block);
        if (this.writeCache != null) {
            this.writeCache.put((Object)id, (Object)block2);
        }
        return block;
    }

    @Override
    public synchronized void write(Block block) {
        this.writeCache(block);
        super.write(block);
    }

    @Override
    public synchronized void overwrite(Block block) {
        Long id = block.getId();
        super.overwrite(block);
        this.readCache.put((Object)id, (Object)block);
    }

    private void writeCache(Block block) {
        Long id = block.getId();
        this.log("WriteCache : %d", id);
        if (this.readCache.containsKey((Object)id)) {
            log.warn("write: Block in the read cache");
        }
        if (this.writeCache != null) {
            this.writeCache.put((Object)id, (Object)block);
            return;
        }
    }

    @Override
    public synchronized void free(Block block) {
        Long id = block.getId();
        this.log("Free  : %d", id);
        if (this.readCache.containsKey((Object)id)) {
            log.warn("Freeing block from read cache");
            this.readCache.remove((Object)id);
        }
        if (this.writeCache != null) {
            this.writeCache.remove((Object)id);
        }
        super.free(block);
    }

    @Override
    public synchronized void sync() {
        this._sync(false);
    }

    @Override
    public synchronized void syncForce() {
        this._sync(true);
    }

    @Override
    public synchronized void close() {
        if (this.writeCache != null) {
            this.log("close (" + this.writeCache.size() + " blocks)", new Object[0]);
        }
        this.syncFlush();
        super.close();
    }

    @Override
    public String toString() {
        return "Cache:" + this.blockMgr.toString();
    }

    private void log(String fmt, Object ... args) {
        if (!this.logging && !globalLogging) {
            return;
        }
        String msg = String.format(fmt, args);
        if (this.getLabel() != null) {
            msg = this.getLabel() + " : " + msg;
        }
        log.debug(msg);
    }

    private void _sync(boolean force) {
        String x = "";
        if (this.getLabel() != null) {
            x = this.getLabel() + " : ";
        }
        this.log("%sH=%d, M=%d, W=%d", x, this.cacheReadHits, this.cacheMisses, this.cacheWriteHits);
        if (this.writeCache != null) {
            this.log("sync (%d blocks)", this.writeCache.size());
        } else {
            this.log("sync", new Object[0]);
        }
        boolean somethingWritten = this.syncFlush();
        if (force) {
            this.log("syncForce underlying BlockMgr", new Object[0]);
            super.syncForce();
        } else if (somethingWritten) {
            this.log("sync underlying BlockMgr", new Object[0]);
            super.sync();
        } else {
            this.log("Empty sync", new Object[0]);
        }
    }

    private boolean syncFlush() {
        if (this.writeCache == null) {
            return false;
        }
        boolean didSync = false;
        this.log("Flush (write cache)", new Object[0]);
        long N = this.writeCache.size();
        Long[] ids = new Long[(int)N];
        Iterator iter = this.writeCache.keys();
        if (iter.hasNext()) {
            didSync = true;
        }
        int i = 0;
        while (iter.hasNext()) {
            ids[i] = (Long)iter.next();
            ++i;
        }
        i = 0;
        while ((long)i < N) {
            Long id = ids[i];
            this.expelEntry(id);
            ++i;
        }
        if (didSync) {
            super.sync();
        }
        return didSync;
    }

    private void expelEntry(Long id) {
        Block block = (Block)this.writeCache.get((Object)id);
        if (block == null) {
            log.warn("Write cache: " + id + " expelling entry that isn't there");
            return;
        }
        this.log("Expel (write cache): %d", id);
        super.write(block);
        this.writeCache.remove((Object)id);
        this.readCache.put((Object)id, (Object)block);
    }
}

