/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.TDBInternal;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;

public class TDBMaker {
    private static DatasetGraphMakerTDB builder = new BuilderStd();

    public static DatasetGraphTransaction createDatasetGraphTransaction(String location) {
        return TDBMaker.createDatasetGraphTransaction(Location.create(location));
    }

    public static DatasetGraphTransaction createDatasetGraphTransaction(Location location) {
        return TDBMaker._create(location);
    }

    public static DatasetGraphTransaction createDatasetGraphTransaction() {
        return TDBMaker.createDatasetGraphTransaction(Location.mem());
    }

    private static DatasetGraphTransaction _create(Location location) {
        return new DatasetGraphTransaction(location);
    }

    public static void releaseLocation(Location location) {
        StoreConnection.release(location);
    }

    public static void reset() {
        StoreConnection.reset();
    }

    public static DatasetGraphTDB createDatasetGraphTDB(Location loc, StoreParams params) {
        return builder.createDatasetGraph(loc, params);
    }

    @Deprecated
    public static DatasetGraphTDB createDatasetGraphTDB(Location loc) {
        return TDBMaker.createDatasetGraphTDB(loc, null);
    }

    private static class BuilderStoreConnectionBase
    implements DatasetGraphMakerTDB {
        private BuilderStoreConnectionBase() {
        }

        @Override
        public DatasetGraphTDB createDatasetGraph(Location location, StoreParams params) {
            return StoreConnection.make(location, params).getBaseDataset();
        }
    }

    private static class _BuilderBase
    implements DatasetGraphMakerTDB {
        private _BuilderBase() {
        }

        @Override
        public DatasetGraphTDB createDatasetGraph(Location location, StoreParams params) {
            if (params != null) {
                System.err.println("StoreParams != null : ignored at the moment");
            }
            DatasetGraph dsg = TDBFactory.createDatasetGraph(location);
            return TDBInternal.getBaseDatasetGraphTDB(dsg);
        }
    }

    private static class BuilderStd
    implements DatasetGraphMakerTDB {
        private BuilderStd() {
        }

        @Override
        public DatasetGraphTDB createDatasetGraph(Location location, StoreParams params) {
            return DatasetBuilderStd.create(location, params);
        }
    }

    private static interface DatasetGraphMakerTDB {
        public DatasetGraphTDB createDatasetGraph(Location var1, StoreParams var2);
    }
}

