/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.BuilderStdIndex;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.IndexParams;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.RangeIndexBuilder;
import com.hp.hpl.jena.tdb.setup.BlockMgrBuilder;
import com.hp.hpl.jena.tdb.setup.StoreParams;

public class IndexFactory {
    private static BlockMgrBuilder blockMgrBuilder = new BuilderStdIndex.BlockMgrBuilderStd();
    private static RangeIndexBuilder rangeIndexBuilder = new BuilderStdIndex.RangeIndexBuilderStd(blockMgrBuilder, blockMgrBuilder);
    private static IndexBuilder indexBuilder = new BuilderStdIndex.IndexBuilderStd(blockMgrBuilder, blockMgrBuilder);

    public static IndexBuilder createIndexBuilderMem() {
        return IndexFactory.createIndexBuilder(IndexFactory.createRangeIndexBuilderMem());
    }

    public static IndexBuilder createIndexBuilder(final RangeIndexBuilder other) {
        return new IndexBuilder(){

            @Override
            public Index buildIndex(FileSet fileSet, RecordFactory recordfactory, IndexParams indexParams) {
                return other.buildRangeIndex(fileSet, recordfactory, indexParams);
            }
        };
    }

    public static RangeIndexBuilder createRangeIndexBuilderMem() {
        return new BuilderStdIndex.RangeIndexBuilderStd(blockMgrBuilder, blockMgrBuilder);
    }

    public static RangeIndex buildRangeIndexMem(RecordFactory recordFactory) {
        FileSet fileSet = FileSet.mem();
        return IndexFactory.buildRangeIndex(fileSet, recordFactory);
    }

    public static RangeIndex buildRangeIndex(Location location, String indexName, RecordFactory recordFactory) {
        FileSet fileset = new FileSet(location, indexName);
        return IndexFactory.buildRangeIndex(fileset, recordFactory);
    }

    public static RangeIndex buildRangeIndex(Location location, String indexName, RecordFactory recordFactory, IndexParams indexParams) {
        FileSet fileset = new FileSet(location, indexName);
        return IndexFactory.buildRangeIndex(fileset, recordFactory, indexParams);
    }

    public static RangeIndex buildRangeIndex(FileSet fileset, RecordFactory recordFactory) {
        StoreParams indexParams = StoreParams.getDftStoreParams();
        return IndexFactory.buildRangeIndex(fileset, recordFactory, indexParams);
    }

    public static RangeIndex buildRangeIndex(FileSet fileset, RecordFactory recordFactory, IndexParams indexParams) {
        return rangeIndexBuilder.buildRangeIndex(fileset, recordFactory, indexParams);
    }

    public static Index buildIndexMem(RecordFactory recordFactory) {
        FileSet fileSet = FileSet.mem();
        return IndexFactory.buildIndex(fileSet, recordFactory);
    }

    public static Index buildIndex(FileSet fileset, RecordFactory recordFactory) {
        StoreParams indexParams = StoreParams.getDftStoreParams();
        return IndexFactory.buildIndex(fileset, recordFactory, indexParams);
    }

    public static Index buildIndex(FileSet fileset, RecordFactory recordFactory, IndexParams indexParams) {
        return indexBuilder.buildIndex(fileset, recordFactory, indexParams);
    }
}

