/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.ExprVars;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.List;
import java.util.Set;

public class TransformTopN
extends TransformCopy {
    private static final int defaultTopNSortingThreshold = 1000;
    public static final Symbol externalSortBufferSize = ARQConstants.allocSymbol("topNSortingThreshold");

    @Override
    public Op transform(OpSlice opSlice, Op inSubOp) {
        List<SortCondition> sortConditions;
        Set<Var> orderVars;
        int threshold;
        long offset;
        Op subOp = inSubOp;
        if (opSlice.getLength() == Long.MIN_VALUE) {
            return this.doNothing(opSlice, inSubOp);
        }
        long limit = opSlice.getLength();
        long N = limit + (offset = opSlice.getStart() != Long.MIN_VALUE ? opSlice.getStart() : 0L);
        if (N >= (long)(threshold = ((Integer)ARQ.getContext().get(externalSortBufferSize, 1000)).intValue())) {
            return this.doNothing(opSlice, inSubOp);
        }
        boolean distinct = false;
        boolean reduce = false;
        if (subOp instanceof OpDistinct) {
            distinct = true;
            subOp = ((Op1)subOp).getSubOp();
        } else if (subOp instanceof OpReduced) {
            distinct = true;
            subOp = ((Op1)subOp).getSubOp();
        }
        List<Var> projection = null;
        if (subOp instanceof OpProject) {
            OpProject opProject = (OpProject)subOp;
            projection = opProject.getVars();
            subOp = opProject.getSubOp();
        }
        if (!(subOp instanceof OpOrder)) {
            return this.doNothing(opSlice, inSubOp);
        }
        OpOrder opOrder = (OpOrder)subOp;
        subOp = opOrder.getSubOp();
        if ((reduce || distinct) && projection != null && !projection.containsAll(orderVars = ExprVars.getVarsMentioned(sortConditions = opOrder.getConditions()))) {
            return this.doNothing(opSlice, inSubOp);
        }
        Op newOp = subOp;
        if ((reduce || distinct) && projection != null) {
            newOp = new OpProject(newOp, projection);
        }
        if (distinct) {
            newOp = OpDistinct.create(newOp);
        }
        if (reduce) {
            newOp = OpReduced.create(newOp);
        }
        newOp = new OpTopN(newOp, (int)N, opOrder.getConditions());
        if (!reduce && !distinct && projection != null) {
            newOp = new OpProject(newOp, projection);
        }
        if (opSlice.getStart() > 0L) {
            newOp = new OpSlice(newOp, opSlice.getStart(), Long.MIN_VALUE);
        }
        return newOp;
    }

    private Op doNothing(OpSlice opSlice, Op subOp) {
        return super.transform(opSlice, subOp);
    }
}

