/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.WriterDatasetRIOTBase;

public abstract class TriGWriterBase
extends WriterDatasetRIOTBase {
    @Override
    public Lang getLang() {
        return Lang.TRIG;
    }

    @Override
    public void write(Writer out, DatasetGraph dsg, PrefixMap prefixMap, String baseURI, Context context) {
        IndentedWriter iOut = RiotLib.create(out);
        this.output$(iOut, dsg, prefixMap, baseURI);
    }

    @Override
    public void write(OutputStream out, DatasetGraph dsg, PrefixMap prefixMap, String baseURI, Context context) {
        IndentedWriter iOut = new IndentedWriter(out);
        this.output$(iOut, dsg, prefixMap, baseURI);
    }

    private void output$(IndentedWriter iOut, DatasetGraph dsg, PrefixMap prefixMap, String baseURI) {
        if (baseURI != null) {
            baseURI = IRIResolver.resolveString(baseURI);
        }
        this.output(iOut, dsg, prefixMap, baseURI);
        iOut.flush();
    }

    protected abstract void output(IndentedWriter var1, DatasetGraph var2, PrefixMap var3, String var4);
}

