/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdPrimitive;
import org.rrd4j.core.RrdUpdater;

class RrdDoubleArray<U extends RrdUpdater<U>>
extends RrdPrimitive<U> {
    private int length;

    RrdDoubleArray(RrdUpdater<U> updater, int length) throws IOException {
        super(updater, 2, length, false);
        this.length = length;
    }

    void set(int index, double value) throws IOException {
        this.set(index, value, 1);
    }

    void set(int index, double value, int count) throws IOException {
        assert (index + count <= this.length) : "Invalid robin index supplied: index=" + index + ", count=" + count + ", length=" + this.length;
        this.writeDouble(index, value, count);
    }

    double get(int index) throws IOException {
        assert (index < this.length) : "Invalid index supplied: " + index + ", length=" + this.length;
        return this.readDouble(index);
    }

    double[] get(int index, int count) throws IOException {
        assert (index + count <= this.length) : "Invalid index/count supplied: " + index + "/" + count + " (length=" + this.length + ")";
        return this.readDouble(index, count);
    }
}

