/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.SetupIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndexRecord;
import org.apache.jena.atlas.lib.ColumnMap;
import org.slf4j.Logger;

public class SetupTDB {
    static final Logger log = TDB.logInfo;
    private static StoreParams params = StoreParams.getDftStoreParams();

    public static void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }

    public static TupleIndex[] makeTupleIndexes(Location location, String primary, String[] descs, String[] filenames) {
        if (primary.length() != 3 && primary.length() != 4) {
            SetupTDB.error(log, "Bad primary key length: " + primary.length());
        }
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[descs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = SetupTDB.makeTupleIndex(location, primary, descs[i], filenames[i], indexRecordLen);
        }
        return indexes;
    }

    public static TupleIndex makeTupleIndex(Location location, String primary, String indexOrder, String indexName, int keyLength) {
        FileSet fs = new FileSet(location, indexName);
        int readCacheSize = params.getBlockReadCacheSize();
        int writeCacheSize = params.getBlockWriteCacheSize();
        RangeIndex rIndex = SetupIndex.makeRangeIndex(location, indexName, params.getBlockSize(), keyLength, 0, readCacheSize, writeCacheSize);
        TupleIndexRecord tupleIndex = new TupleIndexRecord(primary.length(), new ColumnMap(primary, indexOrder), indexOrder, rIndex.getRecordFactory(), rIndex);
        return tupleIndex;
    }

    public static Index makeIndex(Location location, String indexName, int blkSize, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        return SetupIndex.makeIndex(location, indexName, blkSize, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
    }

    public static RangeIndex makeRangeIndex(Location location, String indexName, int blkSize, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        return SetupIndex.makeRangeIndex(location, indexName, blkSize, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
    }

    public static RangeIndex makeBPlusTree(FileSet fs, int blkSize, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        return SetupIndex.makeBPlusTree(fs, blkSize, readCacheSize, writeCacheSize, dftKeyLength, dftValueLength);
    }

    public static RecordFactory makeRecordFactory(int keyLen, int valueLen) {
        return SetupIndex.makeRecordFactory(keyLen, valueLen);
    }

    public static ObjectFile makeObjectFile(FileSet fsIdToNode) {
        String filename = fsIdToNode.filename("dat");
        ObjectFile objFile = FileFactory.createObjectFileDisk(filename);
        return objFile;
    }

    public static RangeIndex createBPTree(FileSet fileset, RecordFactory factory) {
        return SetupIndex.createBPTree(fileset, factory);
    }

    public static RangeIndex createBPTreeByBlockSize(FileSet fileset, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupIndex.createBPTreeByBlockSize(fileset, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static RangeIndex createBPTreeByOrder(FileSet fileset, int order, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupIndex.createBPTreeByOrder(fileset, order, readCacheSize, writeCacheSize, factory);
    }

    public static BPlusTree createBPTree(FileSet fileset, int order, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupIndex.createBPTree(fileset, order, blockSize, readCacheSize, writeCacheSize, factory);
    }
}

