/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.modify.request.QuadAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateVisitor;
import com.hp.hpl.jena.sparql.modify.request.UpdateWithUsing;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.Iso;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.update.Update;
import java.util.List;

public class UpdateModify
extends UpdateWithUsing {
    private final QuadAcc deletePattern = new QuadAcc();
    private final QuadAcc insertPattern = new QuadAcc();
    private boolean hasInsert = false;
    private boolean hasDelete = false;
    private Element wherePattern = null;

    public void setElement(Element element) {
        this.wherePattern = element;
    }

    public QuadAcc getDeleteAcc() {
        return this.deletePattern;
    }

    public QuadAcc getInsertAcc() {
        return this.insertPattern;
    }

    public List<Quad> getDeleteQuads() {
        return this.deletePattern.getQuads();
    }

    public List<Quad> getInsertQuads() {
        return this.insertPattern.getQuads();
    }

    public void setHasInsertClause(boolean flag) {
        this.hasInsert = flag;
    }

    public void setHasDeleteClause(boolean flag) {
        this.hasDelete = flag;
    }

    public boolean hasInsertClause() {
        if (this.hasInsert) {
            return true;
        }
        return this.insertPattern.getQuads().size() > 0;
    }

    public boolean hasDeleteClause() {
        if (this.hasDelete) {
            return true;
        }
        return this.deletePattern.getQuads().size() > 0;
    }

    public Element getWherePattern() {
        return this.wherePattern;
    }

    @Override
    public void visit(UpdateVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equalTo(Update obj, NodeIsomorphismMap isoMap) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateModify other = (UpdateModify)obj;
        if (this.hasDelete != other.hasDelete) {
            return false;
        }
        if (this.hasInsert != other.hasInsert) {
            return false;
        }
        if (!this.equalIso(other, isoMap)) {
            return false;
        }
        if (!Iso.isomorphicQuads(this.getDeleteQuads(), other.getDeleteQuads(), isoMap)) {
            return false;
        }
        if (!Iso.isomorphicQuads(this.getInsertQuads(), other.getInsertQuads(), isoMap)) {
            return false;
        }
        return this.wherePattern.equalTo(other.wherePattern, isoMap);
    }
}

