/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.TypedStream;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.adapters.AdapterLib;
import org.apache.jena.riot.adapters.AdapterLocationMapper;
import org.apache.jena.riot.adapters.FileManagerModelCache;
import org.apache.jena.riot.system.stream.LocatorClassLoader;
import org.apache.jena.riot.system.stream.LocatorFTP;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.apache.jena.riot.system.stream.LocatorHTTP;
import org.apache.jena.riot.system.stream.LocatorZip;
import org.apache.jena.riot.system.stream.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterFileManager
extends FileManager {
    private static Logger log = LoggerFactory.getLogger(AdapterFileManager.class);
    private static AdapterFileManager instance = null;
    private final StreamManager streamManager;
    private FileManagerModelCache modelCache = new FileManagerModelCache();

    public static AdapterFileManager get() {
        if (instance == null) {
            instance = AdapterFileManager.makeGlobal();
        }
        return instance;
    }

    public static void setGlobalFileManager(AdapterFileManager globalFileManager) {
        instance = globalFileManager;
    }

    private AdapterFileManager() {
        this.streamManager = new StreamManager();
    }

    public FileManager clone() {
        StreamManager sm = this.streamManager.clone();
        AdapterFileManager x = new AdapterFileManager(sm);
        return x;
    }

    public AdapterFileManager(StreamManager streamManager) {
        this(streamManager, streamManager == null ? null : streamManager.getLocationMapper());
    }

    public AdapterFileManager(StreamManager streamManager, org.apache.jena.riot.system.stream.LocationMapper mapper) {
        if (streamManager == null) {
            streamManager = new StreamManager();
        }
        this.streamManager = streamManager;
        streamManager.setLocationMapper(mapper);
    }

    public static AdapterFileManager makeGlobal() {
        AdapterFileManager fMgr = new AdapterFileManager(StreamManager.get());
        return fMgr;
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    public void setLocationMapper(LocationMapper mapper) {
        this.streamManager.setLocationMapper(AdapterLib.copyConvert(mapper));
    }

    public LocationMapper getLocationMapper() {
        return new AdapterLocationMapper(this.streamManager.getLocationMapper());
    }

    public Iterator<Locator> locators() {
        throw new UnsupportedOperationException();
    }

    public void remove(Locator loc) {
        throw new UnsupportedOperationException();
    }

    public void addLocator(Locator oldloc) {
        org.apache.jena.riot.system.stream.Locator loc = AdapterLib.convert(oldloc);
        log.debug("Add location: " + loc.getName());
        this.streamManager.addLocator(loc);
    }

    public void addLocatorFile() {
        this.addLocatorFile(null);
    }

    public void addLocatorFile(String dir) {
        LocatorFile fLoc = new LocatorFile(dir);
        this.streamManager.addLocator(fLoc);
    }

    public void addLocatorClassLoader(ClassLoader cLoad) {
        LocatorClassLoader cLoc = new LocatorClassLoader(cLoad);
        this.streamManager.addLocator(cLoc);
    }

    public void addLocatorHTTP() {
        LocatorHTTP loc = new LocatorHTTP();
        this.streamManager.addLocator(loc);
    }

    public void addLocatorFTP() {
        LocatorFTP loc = new LocatorFTP();
        this.streamManager.addLocator(loc);
    }

    public void addLocatorZip(String zfn) {
        LocatorZip loc = new LocatorZip(zfn);
        this.streamManager.addLocator(loc);
    }

    public void resetCache() {
        this.modelCache.resetCache();
    }

    public void setModelCaching(boolean state) {
        this.modelCache.setModelCaching(state);
    }

    public boolean isCachingModels() {
        return this.modelCache.isCachingModels();
    }

    public Model getFromCache(String filenameOrURI) {
        return this.modelCache.getFromCache(filenameOrURI);
    }

    public boolean hasCachedModel(String filenameOrURI) {
        return this.modelCache.hasCachedModel(filenameOrURI);
    }

    public void addCacheModel(String uri, Model m) {
        this.modelCache.addCacheModel(uri, m);
    }

    public void removeCacheModel(String uri) {
        this.modelCache.removeCacheModel(uri);
    }

    protected Model readModelWorker(Model model, String filenameOrURI, String baseURI, String syntax) {
        String mappedURI = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !mappedURI.equals(filenameOrURI)) {
            log.debug("Map: " + filenameOrURI + " => " + mappedURI);
        }
        Lang lang = syntax != null ? RDFLanguages.nameToLang(syntax) : RDFLanguages.resourceNameToLang(mappedURI, Lang.RDFXML);
        RDFDataMgr.read(model, mappedURI, baseURI, lang);
        return model;
    }

    public InputStream open(String filenameOrURI) {
        return this.streamManager.open(filenameOrURI);
    }

    public String mapURI(String filenameOrURI) {
        return this.streamManager.mapURI(filenameOrURI);
    }

    public InputStream openNoMap(String filenameOrURI) {
        return this.streamManager.openNoMap(filenameOrURI);
    }

    public TypedStream openNoMapOrNull(String filenameOrURI) {
        return AdapterLib.convert(this.streamManager.openNoMapOrNull(filenameOrURI));
    }
}

