/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Closeable;

public abstract class PlanBase
extends PrintSerializableBase
implements Plan {
    private Op op = null;
    protected Closeable closeable = null;
    protected boolean closed = false;
    private boolean iteratorProduced = false;

    protected abstract QueryIterator iteratorOnce();

    protected PlanBase(Op op, Closeable closeable) {
        this.op = op;
        this.closeable = closeable;
    }

    @Override
    public Op getOp() {
        return this.op;
    }

    @Override
    public final QueryIterator iterator() {
        if (this.iteratorProduced) {
            throw new ARQInternalErrorException("Attempt to use the iterator twice");
        }
        this.iteratorProduced = true;
        return this.iteratorOnce();
    }

    @Override
    public void output(IndentedWriter out) {
        SerializationContext sCxt = new SerializationContext(ARQConstants.getGlobalPrefixMap());
        this.output(out, sCxt);
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        this.op.output(out, sCxt);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.closeable != null) {
            this.closeable.close();
        }
        this.closed = true;
    }
}

