/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;

public class AggCountVar
extends AggregatorBase {
    public AggCountVar(Expr expr) {
        super("COUNT", false, expr);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggCountVar(expr.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCountVar(this.getExpr());
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.exprList.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggCountVar)) {
            return false;
        }
        AggCountVar agg = (AggCountVar)other;
        return agg.getExpr().equals(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    private static class AccCountVar
    extends AccumulatorExpr {
        private long count = 0L;

        public AccCountVar(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getValue() {
            return this.getAccValue();
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

