/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.configuration.provider;

import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;

public abstract class HierarchicalConfigProvider<T>
implements Provider<T>,
CfgEventListener {
    LinkedList<CfgEventListener> listeners = new LinkedList();
    ConfigurationNode config;

    public HierarchicalConfigProvider() {
    }

    public void addListener(CfgEventListener c) {
        this.listeners.add(c);
    }

    public void removeListener(CfgEventListener x) {
        this.listeners.remove(x);
    }

    protected T fireComponentFound(CfgEvent cfgEvent) {
        for (CfgEventListener cel : this.listeners) {
            Object t = cel.componentFound(cfgEvent);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    public ConfigurationNode getConfig() {
        return this.config;
    }

    public void setConfig(ConfigurationNode config) {
        this.config = config;
    }

    public HierarchicalConfigProvider(ConfigurationNode config) {
        this.config = config;
    }

    public String getAttribute(String key) {
        List list = this.getConfig().getAttributes(key);
        if (list.isEmpty()) {
            return null;
        }
        DefaultConfigurationNode node = (DefaultConfigurationNode)list.get(0);
        return node.getValue().toString();
    }

    protected String getAttribute(String key, String defaultValue) {
        String x = this.getAttribute(key);
        if (x == null) {
            x = defaultValue;
        }
        return x;
    }

    public int getIntAttribute(String key, int defaultValue) {
        String x = this.getAttribute(key);
        if (x == null) {
            return defaultValue;
        }
        return Integer.parseInt(x);
    }

    public int getIntAttribute(String key) {
        return Integer.parseInt(this.getAttribute(key));
    }

    public boolean getBooleanAttribute(String key) {
        return Boolean.parseBoolean(this.getAttribute(key));
    }

    public boolean isA(String name) {
        String x = this.getConfig().getName();
        if (x == null || x.length() == 0) {
            return false;
        }
        return x.equals(name);
    }

    public boolean hasA(String name) {
        return 0 < this.getConfig().getChildren(name).size();
    }

    public ConfigurationNode getConfigurationAt(String name) {
        List list = this.getConfig().getChildren(name);
        if (list.isEmpty()) {
            return null;
        }
        return (ConfigurationNode)list.get(0);
    }

    protected abstract boolean checkEvent(CfgEvent var1);
}

