/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.configuration;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;

public class XProperties
extends Properties {
    static final long serialVersionUID = 42L;
    static final String NAMESPACE_DELIMITER = ":";
    public static String DEFAULT_LIST_SEPARATOR = ",";
    protected String storeFileName = null;
    String _listSeparator;
    public static String[] LOGICAL_TRUES = new String[]{"true", "ok", "yes", "1", "on", "yup", "yeah", "enable", "enabled"};
    public static String[] LOGICAL_FALSES = new String[]{"false", "no", "0", "off", "nope", "nay", "disable", "disabled"};

    public String getListSeparator() {
        if (this._listSeparator == null) {
            this._listSeparator = DEFAULT_LIST_SEPARATOR;
        }
        return this._listSeparator;
    }

    public void setListSeparator(String listSeparator) {
        this._listSeparator = listSeparator;
    }

    public XProperties() {
    }

    public XProperties(String fileName) {
        this.setStoreFileName(fileName);
        this.load();
    }

    public XProperties(File file) {
        try {
            this.setStoreFileName(file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new GeneralException("Error setting property file name", e);
        }
        this.load();
    }

    public XProperties(Properties p) {
        this.add(p, true);
    }

    public XProperties(Properties[] sources, boolean overwrite) {
        this.add(sources, overwrite);
    }

    public XProperties(Properties[] sources, boolean[] overwrite) {
        this.add(sources, overwrite);
    }

    public boolean getBoolean(String key) {
        int i;
        String rawOut = this.getProperty(key);
        String out = rawOut.toLowerCase();
        if (out == null) {
            throw new GeneralException("null value for key >>" + key + "<< encountered.");
        }
        for (i = 0; i < LOGICAL_TRUES.length; ++i) {
            if (!LOGICAL_TRUES[i].equals(out)) continue;
            return true;
        }
        for (i = 0; i < LOGICAL_FALSES.length; ++i) {
            if (!LOGICAL_FALSES[i].equals(out)) continue;
            return false;
        }
        throw new GeneralException("unknown value >" + rawOut + "< for boolean key >" + key + "<");
    }

    public void setBoolean(String key, boolean value) {
        this.setProperty(key, value ? LOGICAL_TRUES[0] : "false");
    }

    public int getInt(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public void setInt(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public long getLong(String key) {
        return Long.parseLong(this.getProperty(key));
    }

    public void setLong(String key, long value) {
        this.setProperty(key, Long.toString(value));
    }

    public File getFile(String key) {
        return new File(this.getProperty(key));
    }

    public File getFile(String key, File parent) {
        return new File(parent, this.getProperty(key));
    }

    public void setFile(String key, File f) {
        try {
            this.setProperty(key, f.getCanonicalPath());
        }
        catch (IOException e) {
            throw new GeneralException("Error setting file property", e);
        }
    }

    public String getString(String key) {
        return this.getProperty(key);
    }

    public void setString(String key, String value) {
        this.setProperty(key, value);
    }

    public Object getSerializable(String key) {
        Object[] x = this.getSerializableList(key);
        if (x == null || x.length == 0) {
            return x;
        }
        return x[0];
    }

    public void setSerializable(String key, Serializable object) {
        Object[] x = new Object[]{object};
        this.setSerializableList(key, x);
    }

    public void setSerializableList(String key, Object[] oList) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(oList);
            oos.flush();
            oos.close();
            this.setProperty(key, Base64.encodeBase64String((byte[])baos.toByteArray()));
        }
        catch (Exception e) {
            throw new GeneralException("Error serializing object", e);
        }
    }

    public Object[] getSerializableList(String key) {
        if (!this.containsKey(key)) {
            return new Object[0];
        }
        byte[] x = Base64.decodeBase64((String)this.getProperty(key));
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(x);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object[] objects = (Object[])ois.readObject();
            ois.close();
            return objects;
        }
        catch (Exception e) {
            throw new GeneralException("Error deserializing list", e);
        }
    }

    public byte[] getBytes(String key) {
        return Base64.decodeBase64((String)this.getProperty(key));
    }

    public void setBytes(String key, byte[] ba) {
        this.setProperty(key, Base64.encodeBase64String((byte[])ba));
    }

    public void setDouble(String key, double value) {
        this.setProperty(key, Double.toString(value));
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.getProperty(key));
    }

    @Override
    public Object setProperty(String key, String value) {
        if (null == this.getProperty(key) && value == null) {
            return null;
        }
        return super.setProperty(key, value);
    }

    public void add(Map source, boolean overwrite) {
        Set e = source.keySet();
        for (Object key : e) {
            if (this.containsKey(key) && !overwrite) continue;
            Object value = source.get(key);
            this.setProperty(key.toString(), value.toString());
        }
    }

    public void add(Properties[] sources, boolean overwrite) {
        for (int i = 0; i < sources.length; ++i) {
            this.add(sources[i], overwrite);
        }
    }

    public void add(Properties[] sources, boolean[] overwrite) {
        if (sources.length != overwrite.length) {
            throw new GeneralException("Properties[" + sources.length + "] and boolean[" + overwrite.length + "] arrays are not the same length.");
        }
        for (int i = 0; i < sources.length; ++i) {
            this.add(sources[i], overwrite[i]);
        }
    }

    public void setDate(String key, Date d) {
        this.setLong(key, d.getTime());
    }

    public URI getURI(String key) {
        if (null == this.getString(key)) {
            throw new GeneralException("Error, a null value for the uri >>" + key + "<< was encountered");
        }
        return URI.create(this.getString(key));
    }

    public void setURI(String key, URI uri) {
        this.setString(key, uri.toString());
    }

    public void setURI(String key, String uriString) {
        this.setURI(key, URI.create(uriString));
    }

    public URL getURL(String key) {
        if (null == this.getString(key)) {
            throw new GeneralException("Error, a null value for the url >>" + key + " << was encountered");
        }
        try {
            return new URL(this.getString(key));
        }
        catch (MalformedURLException e) {
            throw new GeneralException("Malformed url", e);
        }
    }

    public void setURL(String key, URL url) {
        this.setString(key, url.toString());
    }

    public void setURL(String key, String urlString) {
        try {
            this.setURL(key, new URL(urlString));
        }
        catch (MalformedURLException e) {
            throw new GeneralException("Malformed url", e);
        }
    }

    public Date getDate(String key) {
        return new Date(this.getLong(key));
    }

    public String[] getList(String key, String separator) {
        String list = this.getString(key);
        StringTokenizer st = new StringTokenizer(list, separator);
        String[] outS = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            outS[i++] = st.nextToken();
        }
        return outS;
    }

    public String[] getList(String key) {
        return this.getList(key, this.getListSeparator());
    }

    public void setStoreFileName(String fileName) {
        this.storeFileName = fileName;
    }

    public String getStoreFileName() {
        return this.storeFileName;
    }

    public void load() {
        try {
            this.load(this.getStoreFileName());
            FileInputStream fis = new FileInputStream(this.getStoreFileName());
            this.load(fis);
            fis.close();
        }
        catch (Exception e) {
            new GeneralException("Error loading properties", e);
        }
    }

    public void load(String storeFileName) {
        this.load(new File(storeFileName));
    }

    public void load(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            this.load(fis);
            fis.close();
        }
        catch (Exception e) {
            throw new GeneralException("Error loading properties", e);
        }
    }

    public void setList(String key, String list) {
        this.setString(key, list);
    }

    public void setList(String key, String[] list) {
        this.setList(key, list, this.getListSeparator());
    }

    public void store(String header) {
        if (this.getStoreFileName() == null) {
            throw new IllegalStateException("Error, no file set for default save");
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.getStoreFileName());
            this.store(fos, header);
            fos.flush();
        }
        catch (Exception e) {
            throw new GeneralException("Error storing file", e);
        }
    }

    public void store() {
        this.store("");
    }

    public void setList(String key, String[] list, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            String temp = list[i];
            if (temp == null) continue;
            sb.append(temp);
            if (i == list.length - 1) continue;
            sb.append(separator);
        }
        this.setString(key, sb.toString());
    }

    @Override
    public boolean isEmpty() {
        return !this.elements().hasMoreElements();
    }

    @Override
    public Object clone() {
        return new XProperties(this);
    }

    public XProperties getClone() {
        return (XProperties)this.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof XProperties)) {
            return false;
        }
        XProperties xp = (XProperties)obj;
        if (!this.keySubset(xp) || !xp.keySubset(this)) {
            return false;
        }
        Enumeration<Object> thisKeys = this.keys();
        while (thisKeys.hasMoreElements()) {
            String key = (String)thisKeys.nextElement();
            if (this.getProperty(key).equals(xp.getProperty(key))) continue;
            return false;
        }
        return true;
    }

    protected boolean keySubset(XProperties b) {
        Enumeration<Object> bKeys = b.keys();
        while (bKeys.hasMoreElements()) {
            if (this.containsKey(bKeys.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                System.out.println("Usage: a single argument that is a file to be created.\nThe main method for this class is only for showing functionality");
                return;
            }
            XProperties xp = new XProperties();
            xp.setBoolean("boolean.test", true);
            File f = new File(args[0]);
            xp.setFile("file.test", f);
            int integerTest = 123456789;
            xp.setInt("integer.test", integerTest);
            long longTest = System.currentTimeMillis();
            xp.setLong("long.test", longTest);
            String stringTest = "you need more thneeds.";
            xp.setString("string.test", stringTest);
            String b64Test = "Four score and seven years ago,\nour\tfathers\n\nset forth, uh, I forget the rest...";
            Date d = new Date();
            d.setTime(10000000L);
            xp.setDate("date.test", d);
            double dd = Math.random();
            xp.setDouble("double.test", dd);
            Object[] oList = new Object[]{stringTest, new Integer(integerTest), new Double(dd)};
            xp.setSerializableList("serList.test", oList);
            URI uri = new URI("http://foo/bar/baz#fnord");
            xp.setURI("uri.test", uri);
            xp.setBytes("b64.test", b64Test.getBytes());
            String[] testList = new String[]{"foo", "fnord", "fnibble"};
            xp.setList("list.test", testList);
            String customDelimiter = "**";
            xp.setList("list.test2", testList, customDelimiter);
            boolean ok = false;
            xp.setSerializable("ser.test", (Serializable)((Object)b64Test));
            xp.store(new FileOutputStream(args[0]), "test header");
            xp = new XProperties();
            xp.load(new FileInputStream(args[0]));
            xp.list(System.out);
            System.out.println("\n-----\ntesting properties\n-----\n");
            System.out.println("boolean test " + (xp.getBoolean("boolean.test") ? "ok" : "failed"));
            System.out.println("file = " + xp.getFile("file.test"));
            System.out.println("string test " + (xp.getString("string.test").equals(stringTest) ? "ok" : "failed"));
            System.out.println("integer test " + (xp.getInt("integer.test") == integerTest ? "ok" : "failed"));
            System.out.println("long test " + (xp.getLong("long.test") == longTest ? "ok" : "failed"));
            System.out.println("date test " + (xp.getDate("date.test").equals(d) ? "ok" : "failed"));
            System.out.println("double test " + (xp.getDouble("double.test") == dd ? "ok" : "failed"));
            String b64String2 = new String(xp.getBytes("b64.test"));
            System.out.println("byte test " + (b64String2.equals(b64Test) ? "ok" : "failed"));
            System.out.println("byte string = " + b64String2);
            String serTest = (String)xp.getSerializable("ser.test");
            System.out.println("serialized test " + (serTest.equals(b64Test) ? "ok" : "failed"));
            System.out.println("uri.test " + (uri.equals(xp.getURI("uri.test")) ? "ok" : "failed"));
            String[] list1 = xp.getList("list.test2", customDelimiter);
            ok = testList[0].equals(list1[0]) && testList[1].equals(list1[1]) && testList[2].equals(list1[2]);
            System.out.println("list test with custom delimiter " + (ok ? "ok" : "failed"));
            String[] list0 = xp.getList("list.test");
            ok = testList[0].equals(list0[0]) && testList[1].equals(list0[1]) && testList[2].equals(list0[2]);
            System.out.println("list test with default delimiter " + (ok ? "ok" : "failed"));
            Object[] oList2 = xp.getSerializableList("serList.test");
            ok = ((String)oList2[0]).equals(stringTest);
            ok = ok && (Integer)oList[1] == integerTest;
            ok = ok && (Double)oList[2] == dd;
            System.out.println("serialized list test = " + (ok ? "ok" : "failed"));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

