/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;

public class RDFReaderRIOT
implements RDFReader {
    private final String basename;
    private final String hintlang;
    private Context context = new Context();
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public RDFReaderRIOT() {
        this.basename = "org.apache.jena.riot.reader.generic";
        this.hintlang = null;
    }

    public RDFReaderRIOT(String lang) {
        this.basename = "org.apache.jena.riot.reader." + lang.toLowerCase(Locale.ENGLISH);
        this.hintlang = lang;
    }

    public void read(Model model, Reader r, String base) {
        this.startRead(model);
        RDFDataMgr.read(model, r, base, RDFLanguages.nameToLang(this.hintlang));
        this.finishRead(model);
    }

    public void read(Model model, InputStream r, String base) {
        this.startRead(model);
        RDFDataMgr.read(model, r, base, RDFLanguages.nameToLang(this.hintlang));
        this.finishRead(model);
    }

    public void read(Model model, String url) {
        this.startRead(model);
        RDFDataMgr.read(model, url, RDFLanguages.nameToLang(this.hintlang));
        this.finishRead(model);
    }

    public Object setProperty(String propName, Object propValue) {
        Symbol sym = Symbol.create(this.basename + propName);
        Object oldObj = this.context.get(sym);
        return oldObj;
    }

    private void startRead(Model model) {
        model.notifyEvent((Object)GraphEvents.startRead);
    }

    private void finishRead(Model model) {
        model.notifyEvent((Object)GraphEvents.finishRead);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }
}

