/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.ByteUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkConfig
implements DataSerializable {
    public static final int DEFAULT_PORT = 5701;
    private int port = 5701;
    private boolean portAutoIncrement = true;
    private boolean reuseAddress = false;
    private String publicAddress = null;
    private Collection<String> outboundPortDefinitions;
    private Collection<Integer> outboundPorts;
    private Interfaces interfaces = new Interfaces();
    private Join join = new Join();
    private SymmetricEncryptionConfig symmetricEncryptionConfig = null;
    private AsymmetricEncryptionConfig asymmetricEncryptionConfig = null;
    private SocketInterceptorConfig socketInterceptorConfig = null;
    private SSLConfig sslConfig = null;

    public NetworkConfig() {
        String os = System.getProperty("os.name").toLowerCase();
        this.reuseAddress = os.indexOf("win") == -1;
    }

    public int getPort() {
        return this.port;
    }

    public NetworkConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isPortAutoIncrement() {
        return this.portAutoIncrement;
    }

    public NetworkConfig setPortAutoIncrement(boolean portAutoIncrement) {
        this.portAutoIncrement = portAutoIncrement;
        return this;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public NetworkConfig setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this;
    }

    public Collection<String> getOutboundPortDefinitions() {
        return this.outboundPortDefinitions;
    }

    public NetworkConfig setOutboundPortDefinitions(Collection<String> outboundPortDefs) {
        this.outboundPortDefinitions = outboundPortDefs;
        return this;
    }

    public NetworkConfig addOutboundPortDefinition(String portDef) {
        if (this.outboundPortDefinitions == null) {
            this.outboundPortDefinitions = new HashSet<String>();
        }
        this.outboundPortDefinitions.add(portDef);
        return this;
    }

    public Collection<Integer> getOutboundPorts() {
        return this.outboundPorts;
    }

    public NetworkConfig setOutboundPorts(Collection<Integer> outboundPorts) {
        this.outboundPorts = outboundPorts;
        return this;
    }

    public NetworkConfig addOutboundPort(int port) {
        if (this.outboundPorts == null) {
            this.outboundPorts = new HashSet<Integer>();
        }
        this.outboundPorts.add(port);
        return this;
    }

    public Interfaces getInterfaces() {
        return this.interfaces;
    }

    public NetworkConfig setInterfaces(Interfaces interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    public Join getJoin() {
        return this.join;
    }

    public NetworkConfig setJoin(Join join) {
        this.join = join;
        return this;
    }

    public String getPublicAddress() {
        return this.publicAddress;
    }

    public void setPublicAddress(String publicAddress) {
        this.publicAddress = publicAddress;
    }

    public NetworkConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.socketInterceptorConfig = socketInterceptorConfig;
        return this;
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.socketInterceptorConfig;
    }

    public SymmetricEncryptionConfig getSymmetricEncryptionConfig() {
        return this.symmetricEncryptionConfig;
    }

    public NetworkConfig setSymmetricEncryptionConfig(SymmetricEncryptionConfig symmetricEncryptionConfig) {
        this.symmetricEncryptionConfig = symmetricEncryptionConfig;
        return this;
    }

    public AsymmetricEncryptionConfig getAsymmetricEncryptionConfig() {
        return this.asymmetricEncryptionConfig;
    }

    public NetworkConfig setAsymmetricEncryptionConfig(AsymmetricEncryptionConfig asymmetricEncryptionConfig) {
        this.asymmetricEncryptionConfig = asymmetricEncryptionConfig;
        return this;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public NetworkConfig setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.port);
        this.interfaces.writeData(out);
        this.join.writeData(out);
        boolean hasSymmetricEncryptionConfig = this.symmetricEncryptionConfig != null;
        boolean hasAsymmetricEncryptionConfig = this.asymmetricEncryptionConfig != null;
        out.writeByte(ByteUtil.toByte(this.portAutoIncrement, this.reuseAddress, hasSymmetricEncryptionConfig, hasAsymmetricEncryptionConfig));
        if (hasSymmetricEncryptionConfig) {
            this.symmetricEncryptionConfig.writeData(out);
        }
        if (hasAsymmetricEncryptionConfig) {
            this.asymmetricEncryptionConfig.writeData(out);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.port = in.readInt();
        this.interfaces = new Interfaces();
        this.interfaces.readData(in);
        this.join = new Join();
        this.join.readData(in);
        boolean[] b = ByteUtil.fromByte(in.readByte());
        this.portAutoIncrement = b[0];
        this.reuseAddress = b[1];
        boolean hasSymmetricEncryptionConfig = b[2];
        boolean hasAsymmetricEncryptionConfig = b[3];
        if (hasSymmetricEncryptionConfig) {
            this.symmetricEncryptionConfig = new SymmetricEncryptionConfig();
            this.symmetricEncryptionConfig.readData(in);
        }
        if (hasAsymmetricEncryptionConfig) {
            this.asymmetricEncryptionConfig = new AsymmetricEncryptionConfig();
            this.asymmetricEncryptionConfig.readData(in);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkConfig {");
        sb.append("publicAddress='").append(this.publicAddress).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", portAutoIncrement=").append(this.portAutoIncrement);
        sb.append(", join=").append(this.join);
        sb.append(", interfaces=").append(this.interfaces);
        sb.append(", sslConfig=").append(this.sslConfig);
        sb.append(", socketInterceptorConfig=").append(this.socketInterceptorConfig);
        sb.append(", symmetricEncryptionConfig=").append(this.symmetricEncryptionConfig);
        sb.append(", asymmetricEncryptionConfig=").append(this.asymmetricEncryptionConfig);
        sb.append('}');
        return sb.toString();
    }
}

