/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.sample;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.ConnectionNotAvailableException;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;

public class EMLInspectionApp
implements DatabaseConnectionPoolInterface {
    private static final String CONFIG_NAME = "datamanager";
    private static ResourceBundle options = null;
    private static String documentURL = null;

    public EMLInspectionApp() {
        EMLInspectionApp.loadOptions();
    }

    public static void main(String[] args) throws MalformedURLException, IOException, Exception {
        boolean success = true;
        EMLInspectionApp dmm = new EMLInspectionApp();
        success = success && dmm.testParseMetadata();
        System.err.println("Finished all tests, success = " + success + "\n");
        System.exit(0);
    }

    private static void loadOptions() {
        try {
            options = ResourceBundle.getBundle(CONFIG_NAME);
            documentURL = options.getString("documentURL");
        }
        catch (Exception e) {
            System.err.println("Error in loading options: " + e.getMessage());
        }
    }

    private boolean testParseMetadata() {
        boolean success = false;
        DataManager dataManager = DataManager.getInstance(this, null);
        InputStream metadataInputStream = null;
        try {
            URL url = new URL(documentURL);
            metadataInputStream = url.openStream();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (metadataInputStream != null) {
            try {
                DataPackage dataPackage = dataManager.parseMetadata(metadataInputStream);
                success = dataPackage != null;
                Entity[] entities = dataPackage.getEntityList();
                for (int i = 0; i < entities.length; ++i) {
                    Entity e = entities[i];
                    this.display("EntityName", e.getName());
                    Attribute[] attributes = e.getAttributes();
                    for (int j = 0; j < attributes.length; ++j) {
                        Attribute a = attributes[j];
                        this.display("    AttributeName", a.getName());
                        this.display("    AttributeUnit", a.getUnit());
                    }
                    System.out.println();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.err.println("Finished testParseMetadata(), success = " + success + "\n");
        return success;
    }

    private void display(String label, String value) {
        System.out.println(label + ": " + value);
        System.out.flush();
    }

    @Override
    public String getDBAdapterName() {
        return "";
    }

    @Override
    public Connection getConnection() throws SQLException, ConnectionNotAvailableException {
        Connection connection = null;
        return connection;
    }

    @Override
    public boolean returnConnection(Connection conn) {
        boolean success = false;
        return success;
    }
}

