/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.service.connector.Ajpv12InputStream;
import org.apache.tomcat.util.StringManager;

class AJP12RequestAdapter
extends RequestImpl {
    static StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    Socket socket;
    InputStream sin;
    Ajpv12InputStream ajpin;
    boolean shutdown = false;
    boolean isPing = false;
    boolean doLog;

    public AJP12RequestAdapter() {
    }

    public AJP12RequestAdapter(ContextManager cm, Socket s) throws IOException {
        this.socket = s;
        this.contextM = cm;
        this.sin = s.getInputStream();
        this.in = new BufferedServletInputStream(this);
        this.ajpin = new Ajpv12InputStream(this.sin);
        this.doLog = this.contextM.getDebug() > 10;
    }

    public int doRead() throws IOException {
        return this.ajpin.read();
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.ajpin.read(b, off, len);
    }

    private boolean isSameAddress(InetAddress server, InetAddress client) {
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < serverAddr.length) {
            if (serverAddr[i] != clientAddr[i]) {
                match = false;
                break;
            }
            ++i;
        }
        if (match) {
            return true;
        }
        int i2 = 0;
        while (i2 < serverAddr.length) {
            if (serverAddr[i2] != clientAddr[serverAddr.length - 1 - i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    void log(String s) {
        this.contextM.log(s);
    }

    protected void readNextRequest() throws IOException {
        try {
            boolean more = true;
            block18: while (more) {
                int marker = this.ajpin.read();
                switch (marker) {
                    case 1: {
                        this.method = this.ajpin.readString(null);
                        this.contextPath = this.ajpin.readString(null);
                        if ("ROOT".equalsIgnoreCase(this.contextPath)) {
                            this.contextPath = null;
                        }
                        if (this.doLog) {
                            this.log("AJP: CP=" + this.contextPath);
                        }
                        if (this.contextPath != null) {
                            this.context = this.contextM.getContext(this.contextPath);
                        }
                        if (this.doLog) {
                            this.log("AJP: context=" + this.context);
                        }
                        this.servletName = this.ajpin.readString(null);
                        if (this.doLog) {
                            this.log("AJP: servlet=" + this.servletName);
                        }
                        this.serverName = this.ajpin.readString(null);
                        if (this.doLog) {
                            this.log("AJP: serverName=" + this.serverName);
                        }
                        String dummy = this.ajpin.readString(null);
                        this.pathInfo = this.ajpin.readString(null);
                        if (this.doLog) {
                            this.log("AJP: PI=" + this.pathInfo);
                        }
                        this.pathTranslated = this.ajpin.readString(null);
                        if (this.doLog) {
                            this.log("AJP: PT=" + this.pathTranslated);
                        }
                        this.queryString = this.ajpin.readString(null);
                        if (this.doLog) {
                            this.log("AJP: QS=" + this.queryString);
                        }
                        this.remoteAddr = this.ajpin.readString("");
                        if (this.doLog) {
                            this.log("AJP: RA=" + this.remoteAddr);
                        }
                        this.remoteHost = this.ajpin.readString("");
                        if (this.doLog) {
                            this.log("AJP: RH=" + this.remoteHost);
                        }
                        this.remoteUser = this.ajpin.readString(null);
                        if (this.doLog) {
                            this.log("AJP: RU=" + this.remoteUser);
                        }
                        this.authType = this.ajpin.readString(null);
                        if (this.doLog) {
                            this.log("AJP: AT=" + this.authType);
                        }
                        dummy = this.ajpin.readString(null);
                        this.method = this.ajpin.readString(null);
                        if (this.doLog) {
                            this.log("AJP: Meth=" + this.method);
                        }
                        this.requestURI = this.ajpin.readString("");
                        if (this.doLog) {
                            this.log("AJP: URI: " + this.requestURI + " CP:" + this.contextPath + " LP: " + this.lookupPath);
                        }
                        if (this.doLog) {
                            this.log("AJP: URI: " + this.requestURI + " CP:" + this.contextPath + " LP: " + this.lookupPath);
                        }
                        dummy = this.ajpin.readString(null);
                        dummy = this.ajpin.readString(null);
                        this.serverName = this.ajpin.readString("");
                        if (this.doLog) {
                            this.log("AJP: serverName=" + this.serverName);
                        }
                        try {
                            this.serverPort = Integer.parseInt(this.ajpin.readString("80"));
                            if (this.serverPort == 443) {
                                this.setScheme("https");
                            }
                        }
                        catch (Exception exception) {
                            this.serverPort = 80;
                        }
                        dummy = this.ajpin.readString("");
                        dummy = this.ajpin.readString("");
                        dummy = this.ajpin.readString("");
                        this.jvmRoute = this.ajpin.readString("");
                        if (this.jvmRoute.length() == 0) {
                            this.jvmRoute = null;
                        }
                        if (this.doLog) {
                            this.log("AJP: Server jvmRoute=" + this.jvmRoute);
                        }
                        dummy = this.ajpin.readString("");
                        dummy = this.ajpin.readString("");
                        break;
                    }
                    case 5: {
                        String token1 = this.ajpin.readString(null);
                        String token2 = this.ajpin.readString("");
                        this.attributes.put(token1, token2);
                        if (!token1.equals("HTTPS") || !token2.equals("on")) continue block18;
                        this.setScheme("https");
                        break;
                    }
                    case 3: {
                        String token1 = this.ajpin.readString(null);
                        String token2 = this.ajpin.readString("");
                        this.headers.putHeader(token1.toLowerCase(), token2);
                        break;
                    }
                    case 254: {
                        int signal = this.ajpin.read();
                        if (signal == 0) {
                            try {
                                this.socket.getOutputStream().write(0);
                                this.sin.close();
                            }
                            catch (IOException ignored) {
                                System.err.println(ignored);
                            }
                            this.isPing = true;
                            return;
                        }
                        try {
                            InetAddress serverAddr = this.socket.getLocalAddress();
                            InetAddress clientAddr = this.socket.getInetAddress();
                            this.sin.close();
                            if (signal == 15 && this.isSameAddress(serverAddr, clientAddr)) {
                                this.contextM.stop();
                                System.exit(0);
                                this.shutdown = true;
                                return;
                            }
                        }
                        catch (Exception ignored) {
                            System.err.println(ignored);
                        }
                        System.err.println("Signal ignored: " + signal);
                        return;
                    }
                    case 4: 
                    case 255: {
                        more = false;
                        break;
                    }
                    case -1: {
                        throw new IOException("Stream closed prematurely");
                    }
                    default: {
                        throw new IOException("Stream broken");
                    }
                    case 0: 
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            System.err.println("Uncaught exception" + e);
            e.printStackTrace();
        }
        int indexQ = this.requestURI.indexOf("?");
        int rLen = this.requestURI.length();
        if (indexQ > -1 && indexQ < rLen) {
            if (this.doLog) {
                this.log("Orig QS " + this.queryString);
            }
            this.queryString = this.requestURI.substring(indexQ + 1, this.requestURI.length());
            if (this.doLog) {
                this.log("New QS " + this.queryString);
            }
            this.requestURI = this.requestURI.substring(0, indexQ);
        }
        if (this.doLog) {
            this.log("Request: " + this.requestURI);
        }
        if (this.doLog) {
            this.log("Query: " + this.queryString);
        }
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
        this.doLog = this.contextM.getDebug() > 10;
    }

    public void setSocket(Socket s) throws IOException {
        this.socket = s;
        this.sin = s.getInputStream();
        this.in = new BufferedServletInputStream(this);
        this.ajpin = new Ajpv12InputStream(this.sin);
    }
}

