/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.test.AbstractTestReifier;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.PrintUtil;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestSuite;

public class TestInferenceReification
extends AbstractTestReifier {
    public TestInferenceReification(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestInferenceReification.class);
    }

    public Graph getGraph() {
        return this.getGraph(ReificationStyle.Minimal);
    }

    public Graph getGraph(ReificationStyle style) {
        return this.makeInfGraph("", "", style);
    }

    public void testSimpleReification() {
        String rules = "[r1: (?x eh:p ?o) -> (?o rdf:type rdf:Statement) (?o rdf:subject ?x)                         (?o rdf:predicate eh:q) (?o rdf:object 42)]";
        Model m = this.makeInfModel(rules, "r1 p r", ReificationStyle.Standard);
        TestUtil.assertIteratorLength((Iterator)m.listReifiedStatements(), 1);
    }

    public void testBindFixesStyle() {
        this.testBindCopiesStyle(this.ruleBaseReasoner());
        this.testBindCopiesStyle(ReasonerRegistry.getRDFSReasoner());
        this.testBindCopiesStyle(ReasonerRegistry.getTransitiveReasoner());
        this.testBindCopiesStyle(ReasonerRegistry.getOWLMicroReasoner());
        this.testBindCopiesStyle(ReasonerRegistry.getOWLMiniReasoner());
        this.testBindCopiesStyle(ReasonerRegistry.getOWLReasoner());
        this.testBindCopiesStyle(ReasonerRegistry.getRDFSSimpleReasoner());
    }

    private void testBindCopiesStyle(Reasoner r) {
        this.testCopiesStyle(r, ReificationStyle.Minimal);
        this.testCopiesStyle(r, ReificationStyle.Standard);
        this.testCopiesStyle(r, ReificationStyle.Convenient);
    }

    private void testCopiesStyle(Reasoner r, ReificationStyle style) {
        TestInferenceReification.assertEquals((Object)style, (Object)r.bind(this.graphWith("", style)).getReifier().getStyle());
    }

    private Reasoner ruleBaseReasoner() {
        return new FBRuleReasoner(Rule.parseRules((String)""));
    }

    public void testRetainsStyle() {
        this.testRetainsStyle(ReificationStyle.Standard);
        this.testRetainsStyle(ReificationStyle.Convenient);
        this.testRetainsStyle(ReificationStyle.Minimal);
    }

    private void testRetainsStyle(ReificationStyle style) {
        BasicForwardRuleInfGraph g = (BasicForwardRuleInfGraph)this.getGraph(style);
        TestInferenceReification.assertEquals((Object)style, (Object)g.getReifier().getStyle());
        TestInferenceReification.assertEquals((Object)style, (Object)g.getRawGraph().getReifier().getStyle());
        TestInferenceReification.assertEquals((Object)style, (Object)g.getDeductionsGraph().getReifier().getStyle());
    }

    public void testConstructingModelDoesntForcePreparation() {
        Model m = this.makeInfModel("", "");
        if (((BaseInfGraph)m.getGraph()).isPrepared()) {
            TestInferenceReification.fail();
        }
    }

    public void SUPPRESStestReificationCompletion() {
        String rules = "[r1: (?x rdf:subject ?s) (?x rdf:predicate ?p) -> (?x rdf:object eh:bar)]";
        Model m = this.makeInfModel(rules, "r1 rdf:type rdf:Statement; r1 rdf:subject foo; r1 rdf:predicate p");
        RSIterator i = m.listReifiedStatements();
        TestInferenceReification.assertTrue((boolean)i.hasNext());
        TestInferenceReification.assertEquals((Object)TestInferenceReification.triple("foo p bar"), (Object)i.nextRS().getStatement().asTriple());
        TestInferenceReification.assertFalse((boolean)i.hasNext());
    }

    private InfGraph makeInfGraph(String rules, String data, ReificationStyle style) {
        PrintUtil.registerPrefix((String)"eh", (String)"eh:/");
        Graph base = this.graphWith(data, style);
        List ruleList = Rule.parseRules((String)rules);
        return new FBRuleReasoner(ruleList).bind(base);
    }

    private Graph graphWith(String data, ReificationStyle style) {
        return TestInferenceReification.graphAdd(Factory.createDefaultGraph((ReificationStyle)style), data);
    }

    private Model makeInfModel(String rules, String data, ReificationStyle style) {
        return ModelFactory.createModelForGraph((Graph)this.makeInfGraph(rules, data, style));
    }

    private Model makeInfModel(String rules, String data) {
        return this.makeInfModel(rules, data, ReificationStyle.Minimal);
    }
}

