/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.ImportManager;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;

public class TestImportManager
extends AssemblerTestBase {
    public TestImportManager(String name) {
        super(name);
    }

    public void testFollowOwlImports() {
        Model modelToLoad = this.model("this hasMarker B5");
        Model m = this.model("x ja:reasoner y; _x owl:imports eh:/loadMe");
        FixedFileManager fm = new FixedFileManager().add("eh:/loadMe", modelToLoad);
        Model m2 = new ImportManager().withImports((FileManager)fm, m);
        TestImportManager.assertInstanceOf(MultiUnion.class, m2.getGraph());
        TestImportManager.assertIsoModels(modelToLoad.union(m), m2);
    }

    public void testFollowJAImports() {
        Model modelToLoad = this.model("this hasMarker B5");
        Model m = this.model("x ja:reasoner y; _x ja:imports eh:/loadMe");
        FixedFileManager fm = new FixedFileManager().add("eh:/loadMe", modelToLoad);
        Model m2 = new ImportManager().withImports((FileManager)fm, m);
        TestImportManager.assertInstanceOf(MultiUnion.class, m2.getGraph());
        TestImportManager.assertIsoModels(modelToLoad.union(m), m2);
    }

    public void testImportMayBeLiteral() {
        Model modelToLoad = this.model("this hasMarker B5");
        Model m = this.model("x ja:reasoner y; _x ja:imports 'eh:/loadMe'");
        FixedFileManager fm = new FixedFileManager().add("eh:/loadMe", modelToLoad);
        Model m2 = new ImportManager().withImports((FileManager)fm, m);
        TestImportManager.assertInstanceOf(MultiUnion.class, m2.getGraph());
        TestImportManager.assertIsoModels(modelToLoad.union(m), m2);
    }

    public void testBadImportObjectFails() {
        this.testBadImportObjectFails("_bnode");
        this.testBadImportObjectFails("17");
        this.testBadImportObjectFails("'chat'fr");
        this.testBadImportObjectFails("'chat'xsd:wrong");
    }

    private void testBadImportObjectFails(String object) {
        String string = "x ja:imports " + object;
        Model m = this.model(string);
        try {
            new ImportManager().withImports(m);
            TestImportManager.fail((String)("should trap bad import specification " + string));
        }
        catch (BadObjectException e) {
            TestImportManager.assertEquals((Object)TestImportManager.resource("x"), (Object)e.getRoot());
            TestImportManager.assertEquals((Object)TestImportManager.rdfNode(m, object), (Object)e.getObject());
        }
    }

    public void testFollowOwlImportsDeeply() {
        Model m1 = this.model("this hasMarker M1; _x owl:imports M2");
        Model m2 = this.model("this hasMarker M2");
        Model m = this.model("x ja:reasoner y; _x owl:imports M1");
        FixedFileManager fm = new FixedFileManager().add("eh:/M1", m1).add("eh:/M2", m2);
        Model result = new ImportManager().withImports((FileManager)fm, m);
        TestImportManager.assertInstanceOf(MultiUnion.class, result.getGraph());
        TestImportManager.assertIsoModels(m1.union(m2).union(m), result);
    }

    public void testCatchesCircularity() {
        Model m1 = this.model("this hasMarker Mx; _x owl:imports My");
        Model m2 = this.model("this hasMarker My; _x owl:imports Mx");
        FixedFileManager fm = new FixedFileManager().add("eh:/Mx", m1).add("eh:/My", m2);
        Model result = new ImportManager().withImports((FileManager)fm, m1);
        TestImportManager.assertIsoModels(m1.union(m2), result);
    }

    public void testCacheModels() {
        ImportManager im = new ImportManager();
        Model spec = this.model("_x owl:imports M1");
        Model m1 = this.model("this isModel M1");
        FixedFileManager withM1 = new FixedFileManager().add("eh:/M1", m1);
        Model A = im.withImports((FileManager)withM1, spec);
        FixedFileManager none = new FixedFileManager();
        Model B = im.withImports((FileManager)none, spec);
        TestImportManager.assertIsoModels(A, B);
    }

    static class FixedFileManager
    extends FileManager {
        Map map = new HashMap();

        FixedFileManager() {
        }

        public Model loadModel(String URL2) {
            Model result = (Model)this.map.get(URL2);
            if (result == null) {
                Assert.fail((String)("no model for " + URL2));
            }
            return result;
        }

        public FixedFileManager add(String URL2, Model m) {
            this.map.put(URL2, m);
            return this;
        }
    }
}

