/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.Tokenizer;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTokenizer
extends TestCase {
    public TestTokenizer(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTokenizer.class);
    }

    public void testTokenizer() {
        Tokenizer tokenizer = new Tokenizer("a(foo,bar)  'i am a literal' so there", "()[], \t\n\r'", "'", true);
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"a");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"(");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"foo");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)",");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"bar");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)")");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)" ");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)" ");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"'");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"i am a literal");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"'");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)" ");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"so");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)" ");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"there");
        TestTokenizer.assertTrue((!tokenizer.hasMoreTokens() ? 1 : 0) != 0);
        tokenizer = new Tokenizer("a(foo,bar)  'i am a literal' so there", "()[], \t\n\r'", "'", false);
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"a");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"foo");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"bar");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"i am a literal");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"so");
        TestTokenizer.assertEquals((String)tokenizer.nextToken(), (String)"there");
        TestTokenizer.assertTrue((!tokenizer.hasMoreTokens() ? 1 : 0) != 0);
    }
}

