/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.impl.DriverMap;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.test.JenaTestBase;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import junit.framework.TestSuite;

public class TestDriverMap
extends JenaTestBase {
    public TestDriverMap(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDriverMap.class);
    }

    public void testAddDrivers() {
        String className = "some.class.name";
        String otherClassName = "other.class.name";
        TestDriverMap.assertEquals(null, (String)DriverMap.get((String)"test-absent-A"));
        TestDriverMap.assertEquals(null, (String)DriverMap.get((String)"test-Absent-A"));
        TestDriverMap.assertEquals(null, (String)DriverMap.get((String)"Test-absent-A"));
        TestDriverMap.assertEquals(null, (String)DriverMap.get((String)"tEST-absent-A"));
        TestDriverMap.assertEquals(null, (String)DriverMap.get((String)"test-absent-B"));
        TestDriverMap.assertEquals(null, (String)DriverMap.get((String)"test-absent-B"));
        DriverMap.add((String)"test-absent-A", (String)className);
        TestDriverMap.assertEquals((String)className, (String)DriverMap.get((String)"test-absent-A"));
        TestDriverMap.assertEquals((String)className, (String)DriverMap.get((String)"test-absent-A"));
        TestDriverMap.assertEquals((String)className, (String)DriverMap.get((String)"test-Absent-A"));
        TestDriverMap.assertEquals((String)className, (String)DriverMap.get((String)"Test-absent-A"));
        TestDriverMap.assertEquals((String)className, (String)DriverMap.get((String)"tEST-absent-A"));
        TestDriverMap.assertEquals(null, (String)DriverMap.get((String)"test-absent-B"));
        TestDriverMap.assertEquals(null, (String)DriverMap.get((String)"test-absent-B"));
        DriverMap.add((String)"test-absent-B", (String)otherClassName);
        TestDriverMap.assertEquals((String)otherClassName, (String)DriverMap.get((String)"test-absent-B"));
        TestDriverMap.assertEquals((String)otherClassName, (String)DriverMap.get((String)"test-absent-B"));
        TestDriverMap.assertEquals((String)className, (String)DriverMap.get((String)"test-absent-A"));
        TestDriverMap.assertEquals((String)className, (String)DriverMap.get((String)"test-absent-A"));
    }

    public void testBuiltinDrivers() {
        TestDriverMap.assertEquals((String)"com.mysql.jdbc.Driver", (String)DriverMap.get((String)"mysql"));
        TestDriverMap.assertEquals((String)"org.postgresql.Driver", (String)DriverMap.get((String)"postgres"));
        TestDriverMap.assertEquals((String)"org.postgresql.Driver", (String)DriverMap.get((String)"postgresql"));
    }

    public void testNormalDrivers() {
        TestDriverMap.assertEquals((String)"test.fake.Driver", (String)DriverMap.get((String)"test-fake-driver"));
        this.testDrivers(FileManager.get().open("etc/db-default-drivers.n3"));
    }

    public void testExtraDrivers() {
        this.testDrivers(FileManager.get().open("etc/db-extra-drivers.n3"));
    }

    protected void testDrivers(InputStream in) {
        if (in != null) {
            RDFNode ANY = null;
            Model m = ModelFactory.createDefaultModel();
            m.read(in, "", "N3");
            StmtIterator A = m.listStatements(ANY, DriverMap.driverClass, ANY);
            while (A.hasNext()) {
                Statement st = A.nextStatement();
                Resource S = st.getSubject();
                String className = st.getString();
                StmtIterator B = m.listStatements(S, DriverMap.driverName, ANY);
                while (B.hasNext()) {
                    String name = B.nextStatement().getString();
                    TestDriverMap.assertEquals((String)className, (String)DriverMap.get((String)name));
                }
            }
        }
    }
}

