/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTestBase;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestCurrentRDFWG
extends ReasonerTestBase {
    public static final String TEST_DIR = "testing/wg20031010/";
    public static String BASE_RESULTS_URI = "http://jena.sourceforge.net/data/rdf-results.rdf";
    Model testResults;
    Resource jena2;
    protected static Log logger = LogFactory.getLog((Class)TestCurrentRDFWG.class);

    public TestCurrentRDFWG(String name) {
        super(name);
    }

    public void initResults() {
        this.testResults = ModelFactory.createDefaultModel();
        this.jena2 = this.testResults.createResource(BASE_RESULTS_URI + "#jena2");
        this.jena2.addProperty(RDFS.comment, (RDFNode)this.testResults.createLiteral("<a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://jena.sourceforce.net/\">Jena2</a> includes a rule-based inference engine for RDF processing, supporting both forward and backward chaining rules. Its OWL rule set is designed to provide sound but not complete instance resasoning for that fragment of OWL/Full limited to the OWL/lite vocabulary. Inparticular it does not support unionOf/complementOf.", true));
        this.jena2.addProperty(RDFS.label, "Jena2");
        this.testResults.setNsPrefix("results", "http://www.w3.org/2002/03owlt/resultsOntology#");
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        try {
            Resource config = TestCurrentRDFWG.newResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "full");
            TestCurrentRDFWG.constructRDFWGtests(suite, RDFSRuleReasonerFactory.theInstance(), config);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to construct RDF WG test harness", (Throwable)e);
        }
        return suite;
    }

    private static void constructRDFWGtests(TestSuite suite, ReasonerFactory rf, Resource config) throws IOException {
        JenaParameters.enableWhitespaceCheckingOfTypedLiterals = true;
        WGReasonerTester tester = new WGReasonerTester("Manifest.rdf", TEST_DIR);
        Iterator i = tester.listTests().iterator();
        while (i.hasNext()) {
            String test = (String)i.next();
            suite.addTest((Test)new TestReasonerWG(tester, test, rf, config));
        }
    }

    static class TestReasonerWG
    extends TestCase {
        WGReasonerTester tester;
        String test;
        ReasonerFactory reasonerFactory;
        Resource config;

        TestReasonerWG(WGReasonerTester tester, String test, ReasonerFactory reasonerFactory, Resource config) {
            super(test);
            this.tester = tester;
            this.test = test;
            this.reasonerFactory = reasonerFactory;
            this.config = config;
        }

        public void runTest() throws IOException {
            boolean success = this.tester.runTest(this.test, this.reasonerFactory, this, this.config);
        }
    }
}

