/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelCon;
import com.hp.hpl.jena.rdf.model.ModelGraphInterface;
import com.hp.hpl.jena.rdf.model.ModelLock;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public interface Model
extends ModelCon,
ModelGraphInterface,
RDFReaderF,
RDFWriterF,
PrefixMapping,
ModelLock {
    public long size();

    public boolean isEmpty();

    public ResIterator listSubjects();

    public NsIterator listNameSpaces();

    public Resource getResource(String var1);

    public Property getProperty(String var1, String var2);

    public Resource createResource();

    public Resource createResource(AnonId var1);

    public Resource createResource(String var1);

    public Property createProperty(String var1, String var2);

    public Literal createLiteral(String var1, String var2);

    public Literal createLiteral(String var1, boolean var2);

    public Literal createTypedLiteral(String var1, RDFDatatype var2);

    public Literal createTypedLiteral(Object var1, RDFDatatype var2);

    public Literal createTypedLiteral(Object var1);

    public Statement createStatement(Resource var1, Property var2, RDFNode var3);

    public RDFList createList();

    public RDFList createList(Iterator var1);

    public RDFList createList(RDFNode[] var1);

    public Model add(Statement var1);

    public Model add(Statement[] var1);

    public Model remove(Statement[] var1);

    public Model add(List var1);

    public Model remove(List var1);

    public Model add(StmtIterator var1);

    public Model add(Model var1);

    public Model add(Model var1, boolean var2);

    public Model read(String var1);

    public Model read(InputStream var1, String var2);

    public Model read(InputStream var1, String var2, String var3);

    public Model read(Reader var1, String var2);

    public Model read(String var1, String var2);

    public Model read(Reader var1, String var2, String var3);

    public Model read(String var1, String var2, String var3);

    public Model write(Writer var1);

    public Model write(Writer var1, String var2);

    public Model write(Writer var1, String var2, String var3);

    public Model write(OutputStream var1);

    public Model write(OutputStream var1, String var2);

    public Model write(OutputStream var1, String var2, String var3);

    public Model remove(Statement var1);

    public Statement getRequiredProperty(Resource var1, Property var2);

    public Statement getProperty(Resource var1, Property var2);

    public ResIterator listSubjectsWithProperty(Property var1);

    public ResIterator listResourcesWithProperty(Property var1);

    public ResIterator listSubjectsWithProperty(Property var1, RDFNode var2);

    public ResIterator listResourcesWithProperty(Property var1, RDFNode var2);

    public NodeIterator listObjects();

    public NodeIterator listObjectsOfProperty(Property var1);

    public NodeIterator listObjectsOfProperty(Resource var1, Property var2);

    public boolean contains(Resource var1, Property var2);

    public boolean containsResource(RDFNode var1);

    public boolean contains(Resource var1, Property var2, RDFNode var3);

    public boolean contains(Statement var1);

    public boolean containsAny(StmtIterator var1);

    public boolean containsAll(StmtIterator var1);

    public boolean containsAny(Model var1);

    public boolean containsAll(Model var1);

    public boolean isReified(Statement var1);

    public Resource getAnyReifiedStatement(Statement var1);

    public void removeAllReifications(Statement var1);

    public void removeReification(ReifiedStatement var1);

    public StmtIterator listStatements();

    public StmtIterator listStatements(Selector var1);

    public StmtIterator listStatements(Resource var1, Property var2, RDFNode var3);

    public ReifiedStatement createReifiedStatement(Statement var1);

    public ReifiedStatement createReifiedStatement(String var1, Statement var2);

    public RSIterator listReifiedStatements();

    public RSIterator listReifiedStatements(Statement var1);

    public ReificationStyle getReificationStyle();

    public Model query(Selector var1);

    public Model union(Model var1);

    public Model intersection(Model var1);

    public Model difference(Model var1);

    public boolean equals(Object var1);

    public Model begin();

    public Model abort();

    public Model commit();

    public Object executeInTransaction(Command var1);

    public boolean independent();

    public boolean supportsTransactions();

    public boolean supportsSetOperations();

    public boolean isIsomorphicWith(Model var1);

    public void close();

    public Lock getLock();

    public Model register(ModelChangedListener var1);

    public Model unregister(ModelChangedListener var1);

    public Model notifyEvent(Object var1);

    public Model removeAll();

    public Model removeAll(Resource var1, Property var2, RDFNode var3);

    public boolean isClosed();
}

