/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheServiceAdmin;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.jcs.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.CacheListeners;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

class RemoteCacheServer
extends UnicastRemoteObject
implements IRemoteCacheService,
IRemoteCacheObserver,
IRemoteCacheServiceAdmin,
Unreferenced {
    private static final long serialVersionUID = -8072345435941473116L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer = RemoteCacheServer.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServer")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer));
    protected static final boolean timing = true;
    private int puts = 0;
    private final Hashtable cacheListenersMap = new Hashtable();
    private final Hashtable clusterListenersMap = new Hashtable();
    private CompositeCacheManager cacheManager;
    private final Hashtable idTypeMap = new Hashtable();
    private int[] listenerId = new int[1];
    protected IRemoteCacheServerAttributes rcsa;
    private int logInterval = 100;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;
    static /* synthetic */ Class class$org$apache$jcs$engine$behavior$ICacheListener;

    RemoteCacheServer(IRemoteCacheServerAttributes rcsa) throws RemoteException {
        super(rcsa.getServicePort());
        this.rcsa = rcsa;
        this.init(rcsa.getConfigFileName());
    }

    private void init(String prop) {
        this.cacheManager = this.createCacheManager(prop);
        String[] list = this.cacheManager.getCacheNames();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            this.cacheListenersMap.put(name, new CacheListeners(this.cacheManager.getCache(name)));
        }
    }

    private CompositeCacheManager createCacheManager(String prop) {
        CompositeCacheManager hub = CompositeCacheManager.getUnconfiguredInstance();
        if (prop == null) {
            hub.configure("/remote.cache.ccf");
        } else {
            hub.configure(prop);
        }
        return hub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheListeners getCacheListeners(String cacheName) {
        CacheListeners cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName);
        Hashtable hashtable = this.cacheListenersMap;
        synchronized (hashtable) {
            if (cacheListeners == null && (cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName)) == null) {
                cacheListeners = new CacheListeners(this.cacheManager.getCache(cacheName));
                this.cacheListenersMap.put(cacheName, cacheListeners);
            }
        }
        return cacheListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheListeners getClusterListeners(String cacheName) {
        CacheListeners cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName);
        Hashtable hashtable = this.clusterListenersMap;
        synchronized (hashtable) {
            if (cacheListeners == null && (cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName)) == null) {
                cacheListeners = new CacheListeners(this.cacheManager.getCache(cacheName));
                this.clusterListenersMap.put(cacheName, cacheListeners);
            }
        }
        return cacheListeners;
    }

    public void put(ICacheElement item) throws IOException {
        this.update(item);
    }

    public void update(ICacheElement item) throws IOException {
        this.update(item, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ICacheElement item, long requesterId) throws IOException {
        long start = 0L;
        start = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            ++this.puts;
            if (this.puts % this.logInterval == 0) {
                log.info((Object)("puts = " + this.puts));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("In update, put [" + item.getKey() + "] in [" + item.getCacheName() + "]"));
        }
        try {
            CacheListeners cacheDesc = this.getCacheListeners(item.getCacheName());
            item.getVal();
            Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(requesterId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("In update, requesterId = [" + requesterId + "] remoteType = " + remoteTypeL));
            }
            boolean fromCluster = false;
            if (remoteTypeL != null && remoteTypeL == 1) {
                fromCluster = true;
            }
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                block23: {
                    try {
                        CompositeCache c = (CompositeCache)cacheDesc.cache;
                        if (fromCluster) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Put FROM cluster, NOT updating other auxiliaries for region.  requesterId [" + requesterId + "]"));
                            }
                            c.localUpdate(item);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Put NOT from cluster, updating other auxiliaries for region.  requesterId [" + requesterId + "]"));
                            }
                            c.update(item);
                        }
                    }
                    catch (Exception ce) {
                        if (!log.isInfoEnabled()) break block23;
                        log.info((Object)("Exception caught updating item. requesterId [" + requesterId + "] " + ce.getMessage()));
                    }
                }
                if (!fromCluster || fromCluster && this.rcsa.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    if (qlist != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("qlist.length = " + qlist.length));
                        }
                        for (int i = 0; i < qlist.length; ++i) {
                            qlist[i].addPutEvent(item);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"q list is null");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Trouble in Update. requesterId [" + requesterId + "]"), (Throwable)e);
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("put took " + String.valueOf(end - start) + " ms."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICacheEventQueue[] getEventQList(CacheListeners cacheListeners, long requesterId) {
        ICacheEventQueue[] list = null;
        Map map = cacheListeners.eventQMap;
        synchronized (map) {
            list = cacheListeners.eventQMap.values().toArray(new ICacheEventQueue[0]);
        }
        int count = 0;
        for (int i = 0; i < list.length; ++i) {
            ICacheEventQueue q = list[i];
            if (q.isWorking() && q.getListenerId() != requesterId) {
                ++count;
                continue;
            }
            list[i] = null;
        }
        if (count == list.length) {
            return list;
        }
        ICacheEventQueue[] qq = new ICacheEventQueue[count];
        count = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            qq[count++] = list[i];
        }
        return qq;
    }

    public ICacheElement get(String cacheName, Serializable key) throws IOException {
        return this.get(cacheName, key, 0L);
    }

    public ICacheElement get(String cacheName, Serializable key, long requesterId) throws IOException {
        Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(requesterId));
        if (log.isDebugEnabled()) {
            log.debug((Object)("get [" + key + "] from cache [" + cacheName + "] requesterId = [" + requesterId + "] remoteType = " + remoteTypeL));
        }
        boolean fromCluster = false;
        if (remoteTypeL != null && remoteTypeL == 1) {
            fromCluster = true;
        }
        CacheListeners cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e) {
            log.error((Object)"Problem getting listeners.", (Throwable)e);
        }
        if (cacheDesc == null) {
            return null;
        }
        CompositeCache c = (CompositeCache)cacheDesc.cache;
        ICacheElement element = null;
        if (!fromCluster && this.rcsa.getAllowClusterGet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("NonLocalGet. fromCluster [" + fromCluster + "] AllowClusterGet [" + this.rcsa.getAllowClusterGet() + "]"));
            }
            element = c.get(key);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("LocalGet.  fromCluster [" + fromCluster + "] AllowClusterGet [" + this.rcsa.getAllowClusterGet() + "]"));
            }
            element = c.localGet(key);
        }
        return element;
    }

    public Set getGroupKeys(String cacheName, String group) {
        CacheListeners cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e) {
            log.error((Object)"Problem getting listeners.", (Throwable)e);
        }
        if (cacheDesc == null) {
            return Collections.EMPTY_SET;
        }
        CompositeCache c = (CompositeCache)cacheDesc.cache;
        return c.getGroupKeys(group);
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String cacheName, Serializable key, long requesterId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove [" + key + "] from cache [" + cacheName + "]"));
        }
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(requesterId));
        boolean fromCluster = false;
        if (remoteTypeL != null && remoteTypeL == 1) {
            fromCluster = true;
        }
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                boolean removeSuccess = false;
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Remove FROM cluster, NOT updating other auxiliaries for region");
                    }
                    removeSuccess = c.localRemove(key);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Remove NOT from cluster, updating other auxiliaries for region");
                    }
                    removeSuccess = c.remove(key);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("remove [" + key + "] from cache [" + cacheName + "] success (was it found) = " + removeSuccess));
                }
                if (!fromCluster || fromCluster && this.rcsa.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    for (int i = 0; i < qlist.length; ++i) {
                        qlist[i].addRemoveEvent(key);
                    }
                }
            }
        }
    }

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(requesterId));
        boolean fromCluster = false;
        if (remoteTypeL != null && remoteTypeL == 1) {
            fromCluster = true;
        }
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"RemoveALL FROM cluster, NOT updating other auxiliaries for region");
                    }
                    c.localRemoveAll();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"RemoveALL NOT from cluster, updating other auxiliaries for region");
                    }
                    c.removeAll();
                }
                if (!fromCluster || fromCluster && this.rcsa.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    for (int i = 0; i < qlist.length; ++i) {
                        qlist[i].addRemoveAllEvent();
                    }
                }
            }
        }
    }

    protected int getPutCount() {
        return this.puts;
    }

    public void dispose(String cacheName) throws IOException {
        this.dispose(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc;
        if (log.isInfoEnabled()) {
            log.info((Object)("Dispose request received from listener [" + requesterId + "]"));
        }
        if ((cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName)) != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                for (int i = 0; i < qlist.length; ++i) {
                    qlist[i].addDisposeEvent();
                }
                this.cacheManager.freeCache(cacheName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws IOException {
        Hashtable hashtable = this.cacheListenersMap;
        synchronized (hashtable) {
            Enumeration en = this.cacheListenersMap.elements();
            while (en.hasMoreElements()) {
                CacheListeners cacheDesc = (CacheListeners)en.nextElement();
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, 0L);
                for (int i = 0; i < qlist.length; ++i) {
                    qlist[i].addDisposeEvent();
                }
            }
            this.cacheManager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupEventQMap(Map eventQMap) {
        Map map = eventQMap;
        synchronized (map) {
            Iterator itr = eventQMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = itr.next();
                ICacheEventQueue q = (ICacheEventQueue)e.getValue();
                if (q.isWorking()) continue;
                itr.remove();
                log.warn((Object)("Cache event queue " + q + " is not working and removed from cache server."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(String cacheName, ICacheListener listener) throws IOException {
        CacheListeners cacheDesc;
        if (cacheName == null || listener == null) {
            throw new IllegalArgumentException("cacheName and listener must not be null");
        }
        IRemoteCacheListener ircl = (IRemoteCacheListener)listener;
        String listenerAddress = ircl.getLocalHostAddress();
        int remoteType = ircl.getRemoteType();
        if (remoteType == 1) {
            log.debug((Object)("adding cluster listener, listenerAddress [" + listenerAddress + "]"));
            cacheDesc = this.getClusterListeners(cacheName);
        } else {
            log.debug((Object)("adding normal listener, listenerAddress [" + listenerAddress + "]"));
            cacheDesc = this.getCacheListeners(cacheName);
        }
        Map eventQMap = cacheDesc.eventQMap;
        RemoteCacheServer.cleanupEventQMap(eventQMap);
        Class clazz = class$org$apache$jcs$engine$behavior$ICacheListener == null ? (class$org$apache$jcs$engine$behavior$ICacheListener = RemoteCacheServer.class$("org.apache.jcs.engine.behavior.ICacheListener")) : class$org$apache$jcs$engine$behavior$ICacheListener;
        synchronized (clazz) {
            long id = 0L;
            try {
                id = listener.getListenerId();
                if (id == 0L) {
                    long listenerIdB = this.nextListenerId();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("listener id=" + (listenerIdB & 0xFFL) + " addded for cache [" + cacheName + "], listenerAddress [" + listenerAddress + "]"));
                    }
                    listener.setListenerId(listenerIdB);
                    id = listenerIdB;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("adding vm listener under new id = [" + listenerIdB + "], listenerAddress [" + listenerAddress + "]"));
                    }
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("adding listener under existing id = [" + id + "], listenerAddress [" + listenerAddress + "]"));
                }
                this.idTypeMap.put(new Long(id), new Integer(remoteType));
            }
            catch (IOException ioe) {
                log.error((Object)("Problem setting listener id, listenerAddress [" + listenerAddress + "]"), (Throwable)ioe);
            }
            CacheEventQueueFactory fact = new CacheEventQueueFactory();
            ICacheEventQueue q = fact.createCacheEventQueue(listener, id, cacheName, this.rcsa.getEventQueuePoolName(), this.rcsa.getEventQueueTypeFactoryCode());
            eventQMap.put(new Long(listener.getListenerId()), q);
            if (log.isInfoEnabled()) {
                log.info((Object)("Region " + cacheName + "'s listener size = " + cacheDesc.eventQMap.size()));
            }
        }
    }

    public void addCacheListener(ICacheListener listener) throws IOException {
        Enumeration en = this.cacheListenersMap.keys();
        while (en.hasMoreElements()) {
            String cacheName = (String)en.nextElement();
            this.addCacheListener(cacheName, listener);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Adding listener for cache [" + cacheName + "]"));
        }
    }

    public void removeCacheListener(String cacheName, ICacheListener listener) throws IOException {
        this.removeCacheListener(cacheName, listener.getListenerId());
    }

    public void removeCacheListener(String cacheName, long listenerId) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing listener for cache region = [" + cacheName + "] and listenerId [" + listenerId + "]"));
        }
        Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(listenerId));
        boolean isClusterListener = false;
        if (remoteTypeL != null && remoteTypeL == 1) {
            isClusterListener = true;
        }
        CacheListeners cacheDesc = null;
        cacheDesc = isClusterListener ? this.getClusterListeners(cacheName) : this.getCacheListeners(cacheName);
        Map eventQMap = cacheDesc.eventQMap;
        RemoteCacheServer.cleanupEventQMap(eventQMap);
        ICacheEventQueue q = (ICacheEventQueue)eventQMap.remove(new Long(listenerId));
        if (q != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found queue for cache region = [" + cacheName + "] and listenerId  [" + listenerId + "]"));
            }
            q.destroy();
            RemoteCacheServer.cleanupEventQMap(eventQMap);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Did not find queue for cache region = [" + cacheName + "] and listenerId [" + listenerId + "]"));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("After removing listener [" + listenerId + "] cache region " + cacheName + "'s listener size [" + cacheDesc.eventQMap.size() + "]"));
        }
    }

    public void removeCacheListener(ICacheListener listener) throws IOException {
        Enumeration en = this.cacheListenersMap.keys();
        while (en.hasMoreElements()) {
            String cacheName = (String)en.nextElement();
            this.removeCacheListener(cacheName, listener);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Removing listener for cache [" + cacheName + "]"));
        }
    }

    public void shutdown() throws IOException {
        RemoteCacheServerFactory.shutdownImpl("", 1099);
    }

    public void shutdown(String host, int port) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Received shutdown request.  Shutting down server.");
        }
        RemoteCacheServerFactory.shutdownImpl(host, port);
        this.cacheManager.shutDown();
    }

    public void unreferenced() {
        if (log.isInfoEnabled()) {
            log.info((Object)"*** Server now unreferenced and subject to GC. ***");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextListenerId() {
        long id = 0L;
        if ((long)this.listenerId[0] == Long.MAX_VALUE) {
            int[] nArray = this.listenerId;
            synchronized (this.listenerId) {
                id = this.listenerId[0];
                this.listenerId[0] = 0;
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        int[] nArray = this.listenerId;
        synchronized (this.listenerId) {
            this.listenerId[0] = this.listenerId[0] + 1;
            id = this.listenerId[0];
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return id;
        }
    }

    public String getStats() throws IOException {
        return this.cacheManager.getStats();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

