/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Barrier;
import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public Rendezvous(int parties) {
        this(parties, new Rotator());
    }

    public Rendezvous(int parties, RendezvousFunction function) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = parties;
        this.rendezvousFunction_ = function;
        this.entryGate_ = new WaiterPreferenceSemaphore(parties);
        this.slots_ = new Object[parties];
    }

    public Object attemptRendezvous(Object x, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(x, true, msecs);
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    /*
     * Unable to fully structure code
     */
    protected Object doRendezvous(Object x, boolean timed, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        if (timed) {
            startTime = System.currentTimeMillis();
            if (!this.entryGate_.attempt(msecs)) {
                throw new TimeoutException(msecs);
            }
        } else {
            startTime = 0L;
            this.entryGate_.acquire();
        }
        var8_5 = this;
        synchronized (var8_5) {
            block22: {
                block21: {
                    block20: {
                        y = null;
                        index = this.entries_++;
                        this.slots_[index] = x;
                        try {
                            if (this.entries_ != this.parties_) ** GOTO lbl43
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            try {
                                if (!this.broken_ && this.rendezvousFunction_ != null) {
                                    this.rendezvousFunction_.rendezvousFunction(this.slots_);
                                }
                                break block20;
                            }
                            catch (RuntimeException v0) {
                                this.broken_ = true;
                            }
                            break block20;
lbl-1000:
                            // 1 sources

                            {
                                timeLeft = 0L;
                                if (timed && (timeLeft = msecs - (System.currentTimeMillis() - startTime)) <= 0L) {
                                    this.broken_ = true;
                                    this.departures_ = this.entries_;
                                    this.notifyAll();
                                    throw new TimeoutException(msecs);
                                }
                                try {
                                    this.wait(timeLeft);
                                }
                                catch (InterruptedException ex) {
                                    if (this.broken_ || this.departures_ > 0L) {
                                        Thread.currentThread().interrupt();
                                        break block20;
                                    }
                                    this.broken_ = true;
                                    this.departures_ = this.entries_;
                                    this.notifyAll();
                                    throw ex;
                                }
lbl43:
                                // 2 sources

                                if (this.broken_) break block20;
                                ** while (this.departures_ < 1L)
                            }
                        }
                        catch (Throwable var12_14) {
                            var13_13 = null;
                            y = this.slots_[index];
                            if (--this.departures_ > 0L) break block21;
                            i = 0;
                            ** while (i < this.slots_.length)
                        }
lbl45:
                        // 1 sources

                    }
                    var13_12 = null;
                    y = this.slots_[index];
                    if (--this.departures_ <= 0L) {
                        i = 0;
                        while (i < this.slots_.length) {
                            this.slots_[i] = null;
                            ++i;
                        }
                        this.entryGate_.release(this.entries_);
                        this.entries_ = 0;
                    }
                    break block22;
lbl-1000:
                    // 1 sources

                    {
                        this.slots_[i] = null;
                        ++i;
                        continue;
                    }
lbl68:
                    // 1 sources

                    this.entryGate_.release(this.entries_);
                    this.entries_ = 0;
                }
                throw var12_14;
            }
            if (this.broken_) {
                throw new BrokenBarrierException(index);
            }
            var7_15 = y;
            var9_16 = null;
            return var7_15;
        }
    }

    public int parties() {
        return this.parties_;
    }

    public Object rendezvous(Object x) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(x, false, 0L);
    }

    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    Object var2_2 = null;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction function) {
        RendezvousFunction old = this.rendezvousFunction_;
        this.rendezvousFunction_ = function;
        return old;
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }

    public static class Rotator
    implements RendezvousFunction {
        public void rendezvousFunction(Object[] objects) {
            int lastIdx = objects.length - 1;
            Object first = objects[0];
            int i = 0;
            while (i < lastIdx) {
                objects[i] = objects[i + 1];
                ++i;
            }
            objects[lastIdx] = first;
        }
    }
}

