/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.utilint.Tracer;
import java.io.File;
import java.io.PrintStream;
import java.util.logging.Level;

public class DbVerify {
    protected File envHome = null;
    protected Environment env;
    protected String dbName = null;
    protected boolean quiet = false;
    private String usageString = "usage: DbVerify [-q] [-V]\n                -s database -h dbEnvHome\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws DatabaseException {
        DbVerify verifier = new DbVerify();
        verifier.parseArgs(argv);
        try {
            boolean ret = verifier.verify(System.err);
            System.exit(ret ? 0 : -1);
        }
        catch (Throwable T) {
            if (verifier.quiet) {
                System.exit(1);
            } else {
                T.printStackTrace(System.err);
            }
        }
        finally {
            verifier.env.close();
        }
    }

    protected DbVerify() {
    }

    public DbVerify(Environment env, String dbName, boolean quiet) {
        this.env = env;
        this.dbName = dbName;
        this.quiet = quiet;
    }

    protected void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(this.usageString);
        System.exit(-1);
    }

    protected void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (!thisArg.equals("-s")) continue;
            if (argc < nArgs) {
                this.dbName = argv[argc++];
                continue;
            }
            this.printUsage("-s requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
        if (this.dbName == null) {
            this.printUsage("-s is a required argument");
        }
    }

    protected void openEnv() throws DatabaseException {
        if (this.env == null) {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setReadOnly(true);
            this.env = new Environment(this.envHome, envConfig);
        }
    }

    public boolean verify(PrintStream out) throws DatabaseException {
        this.openEnv();
        Tracer.trace(Level.INFO, DbInternal.envGetEnvironmentImpl(this.env), "DbVerify.verify of " + this.dbName + " starting");
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(true);
        dbConfig.setAllowCreate(false);
        DbInternal.setUseExistingConfig(dbConfig, true);
        Database db = this.env.openDatabase(null, this.dbName, dbConfig);
        VerifyConfig verifyConfig = new VerifyConfig();
        verifyConfig.setPrintInfo(true);
        boolean ret = db.verify(verifyConfig, out);
        db.close();
        Tracer.trace(Level.INFO, DbInternal.envGetEnvironmentImpl(this.env), "DbVerify.verify of " + this.dbName + " ending");
        return ret;
    }
}

